set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9738659';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      41,
      NULL,
      '2323334',
      NULL,
      3,
      1,
      1,
      '214301',
      0.065133,
      ' 2-29-1983',
      24.596283,
      NULL,
      1,
      NULL,
      1,
      1.670417,
      NULL,
      NULL,
      1.285686,
      2.156219,
      1,
      3,
      0.960022,
      0,
      NULL,
      1,
      0.447659,
      1.720110,
      NULL,
      8,
      NULL,
      NULL,
      0,
      1.995124,
      1,
      1.093549,
      8.085717,
      1,
      NULL,
      3,
      2.217192,
      1.749558,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.883848,
      0,
      1,
      3,
      NULL,
      0.349713,
      0,
      1,
      NULL,
      2,
      1.583659,
      2.100751,
      1.217906,
      1,
      1,
      0,
      2,
      0,
      1,
      1.630808,
      0,
      0,
      1.295802,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.128943,
      4,
      1,
      1.347281,
      NULL,
      NULL,
      3.351496,
      0.568175,
      1,
      3,
      NULL,
      1,
      0,
      3.783981,
      0,
      0.400427,
      1,
      1,
      0,
      NULL,
      1.085035,
      0,
      1,
      1,
      0.442296,
      0.785284,
      3,
      NULL,
      3.529875,
      1,
      1.625019,
      1,
      1,
      1,
      1,
      4,
      0,
      4.476261,
      0.975116,
      6,
      3,
      1.346580,
      NULL,
      1.705740,
      7,
      3.639565,
      0.380347,
      3,
      2.634229,
      NULL,
      0,
      1.731109,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.516661,
      1.138914,
      1,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.632507,
      NULL,
      2.607076,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.685707,
      NULL,
      1.343550,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.094820,
      5,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.080859,
      1,
      0.927847,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1,
      0.088542,
      NULL,
      1,
      0,
      1.009984,
      NULL,
      1.955010,
      0.115970,
      1,
      NULL,
      0,
      1,
      1.129376,
      NULL,
      0.793590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.204832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '31211',
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      1.145360,
      '',
      '',
      '',
      0.957819,
      0,
      8,
      0,
      3,
      NULL,
      3,
      0.566213,
      3);
commit;
end;
/


