set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9738659';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-4-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '341',
      '14322014',
      NULL,
      33.572097,
      '1211201',
      25.877289,
      1,
      2,
      NULL,
      NULL,
      0.920744,
      '10-13-1982',
      48,
      0.168210,
      0,
      NULL,
      NULL,
      0,
      2.355458,
      0.772884,
      0,
      1.012876,
      1,
      NULL,
      1,
      1,
      0.317029,
      NULL,
      NULL,
      1,
      0.892918,
      5,
      0,
      0,
      1,
      NULL,
      NULL,
      1.664006,
      3.279631,
      1,
      0,
      3.164041,
      2.610912,
      1,
      NULL,
      NULL,
      0.596861,
      NULL,
      NULL,
      NULL,
      0,
      1.133813,
      2.818583,
      1.706225,
      0.401540,
      1,
      0.614269,
      0.851897,
      3.105281,
      0,
      1.681987,
      2,
      1.724005,
      2.721619,
      0.826743,
      1.690010,
      2,
      2,
      NULL,
      0,
      0.931408,
      5.148003,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.760903,
      1,
      NULL,
      1.912272,
      0.269279,
      0.575381,
      0,
      0.818242,
      0,
      1.457038,
      NULL,
      1.344196,
      1.273460,
      1.245224,
      0,
      1,
      0,
      1,
      0.907037,
      NULL,
      1,
      3,
      NULL,
      1.922992,
      1,
      0.561146,
      NULL,
      1.859830,
      0,
      1.838272,
      1,
      0,
      0,
      0.051961,
      4.387548,
      3.332556,
      NULL,
      3,
      0,
      NULL,
      5,
      0,
      6,
      4,
      6,
      2,
      NULL,
      3,
      3,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.993589,
      1.642145,
      NULL,
      NULL,
      0.152707,
      1,
      1.134528,
      1.948072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.983928,
      NULL,
      NULL,
      0,
      0,
      1.236656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.603790,
      5.922217,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.387482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.209684,
      2.891275,
      NULL,
      NULL,
      2,
      0.466305,
      NULL,
      1,
      3,
      2.988605,
      1.353964,
      1.844054,
      NULL,
      0,
      0.247616,
      NULL,
      0,
      0.079829,
      0.541416,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.179074,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.037036,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      NULL,
      0.487963,
      '',
      '',
      '',
      2,
      4.949536,
      2,
      0,
      1.981249,
      0.401582,
      1.181703,
      NULL,
      NULL);
commit;
end;
/


