set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7223768';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '302',
      '34032104',
      19,
      34,
      '0312402',
      55.919793,
      4,
      0,
      2,
      '214433',
      4,
      ' 3- 0-1992',
      87,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.527836,
      0.778608,
      0,
      0,
      1.033330,
      1,
      3.349900,
      1,
      1.749440,
      1,
      NULL,
      NULL,
      1.616599,
      NULL,
      1,
      1,
      1,
      0.064475,
      0,
      0,
      7,
      NULL,
      3,
      1.082185,
      0.164281,
      1.046569,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.705643,
      1.341163,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      1.823524,
      4.359970,
      0,
      2,
      1,
      0,
      NULL,
      NULL,
      0.586550,
      NULL,
      NULL,
      1,
      5,
      5.716270,
      NULL,
      4.576541,
      2.865889,
      NULL,
      0.374235,
      NULL,
      1.637668,
      1,
      0,
      1.915886,
      0,
      NULL,
      NULL,
      0.292901,
      NULL,
      NULL,
      NULL,
      1,
      3.717934,
      1,
      NULL,
      0.427010,
      0.874821,
      1,
      1.494480,
      1.638837,
      0,
      1,
      4.084290,
      0,
      1,
      3,
      NULL,
      NULL,
      4,
      1.608219,
      NULL,
      3,
      5.082365,
      0.890483,
      8,
      4,
      NULL,
      1,
      2,
      2,
      1,
      1.637583,
      4.193054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      1,
      0,
      1.354674,
      1.255502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.196982,
      NULL,
      NULL,
      NULL,
      NULL,
      3.260244,
      3,
      3.888961,
      0.768348,
      0.031060,
      1.287886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.344194,
      10,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      2.833503,
      3,
      1,
      3,
      NULL,
      3.361121,
      0.851004,
      1,
      0,
      0.562195,
      NULL,
      0,
      0.355713,
      1,
      1.851306,
      1.052792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      '23241',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      0.251055,
      '',
      '',
      NULL,
      2.815875,
      4.717558,
      1,
      2.954472,
      2.859712,
      2,
      0.775345,
      3.128565,
      0.940745);
commit;
end;
/


