set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7223768';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-5-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '442',
      '20112044',
      33.686496,
      13.735424,
      NULL,
      46,
      6,
      3,
      NULL,
      '414414',
      NULL,
      '11- 3-1997',
      47.779570,
      NULL,
      0.932562,
      NULL,
      0.744254,
      2.937514,
      0.938961,
      0.258711,
      1,
      2,
      1.775382,
      0,
      1.811298,
      NULL,
      5,
      0.495354,
      4.983870,
      1.191316,
      0.262667,
      NULL,
      3,
      5,
      5,
      0.561570,
      1.443869,
      1.317380,
      4,
      0,
      NULL,
      0,
      4.163023,
      1.142812,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.745065,
      NULL,
      0,
      1.571060,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.057072,
      NULL,
      3.177340,
      1,
      1,
      1,
      0.531051,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.093930,
      0,
      NULL,
      0,
      4.736891,
      3.531481,
      2,
      1,
      0.533172,
      0,
      1.967728,
      NULL,
      1.097739,
      NULL,
      NULL,
      0,
      NULL,
      0.980136,
      0.448742,
      NULL,
      0,
      0.645214,
      1,
      0.591828,
      1.070660,
      NULL,
      2,
      NULL,
      5.523883,
      0,
      0.019351,
      NULL,
      0,
      0.360998,
      5,
      1,
      NULL,
      9.063162,
      0.115007,
      7.234539,
      NULL,
      7.594147,
      8.429173,
      5,
      4,
      5.892046,
      0,
      NULL,
      2.149576,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1.738381,
      NULL,
      0.114124,
      1.034990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.505408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.849214,
      2,
      1,
      0,
      11.753834,
      0.186701,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.139713,
      NULL,
      4.543923,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1.011311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2.489270,
      2.366200,
      2.231019,
      3.529719,
      3.474150,
      NULL,
      NULL,
      3,
      0.221940,
      0.995556,
      0.337574,
      0.845107,
      NULL,
      0.934740,
      1,
      NULL,
      1.034584,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '03140',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      3.373335,
      4,
      2,
      5.509939,
      3,
      2,
      1.549151,
      2,
      2.047196);
commit;
end;
/


