set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7223768';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '233',
      '40033243',
      27,
      1.063240,
      '4304334',
      NULL,
      3,
      0.407851,
      1,
      '214313',
      1,
      ' 1-15-1994',
      NULL,
      NULL,
      1.452375,
      NULL,
      1,
      1.250244,
      NULL,
      0.876860,
      1.102863,
      0,
      1,
      1,
      0.517731,
      NULL,
      NULL,
      1,
      3,
      1.953846,
      NULL,
      1.826923,
      0.706910,
      NULL,
      0,
      1,
      1.829667,
      NULL,
      1,
      1,
      5,
      2.985199,
      2,
      1.915492,
      NULL,
      NULL,
      0.863426,
      NULL,
      NULL,
      0,
      NULL,
      0.436646,
      1.516581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.035995,
      NULL,
      1.133484,
      5,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.719287,
      NULL,
      NULL,
      1.972927,
      0.527714,
      NULL,
      1.074420,
      3,
      1,
      NULL,
      NULL,
      1,
      1,
      0.752196,
      5,
      1,
      1,
      1.478046,
      1.470114,
      0.275678,
      NULL,
      0,
      NULL,
      1.190503,
      0,
      0.952633,
      0.957686,
      1,
      NULL,
      1.274245,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.197026,
      1,
      0.747966,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      2.661773,
      NULL,
      0.322705,
      0.812907,
      NULL,
      1,
      1.344193,
      0,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.281405,
      1.389672,
      1,
      0,
      0.610614,
      0.708184,
      0.020576,
      0.023172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.401840,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      1.943558,
      NULL,
      NULL,
      NULL,
      0.667006,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      2.424425,
      0.966278,
      1.446085,
      NULL,
      1,
      0,
      NULL,
      0.546368,
      0,
      1,
      1.480663,
      1,
      0,
      1.851571,
      1.612339,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      3,
      NULL,
      5.648018,
      NULL,
      7,
      NULL,
      0.063804,
      2);
commit;
end;
/


