set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7223768';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4430',
      '10411120',
      54,
      91.475516,
      NULL,
      93.067626,
      5,
      3,
      0,
      '000141',
      3,
      ' 8- 0-1991',
      27,
      53,
      NULL,
      NULL,
      NULL,
      0.683023,
      1,
      1.450798,
      1.895564,
      1.332832,
      NULL,
      0,
      0,
      1,
      4.653805,
      0,
      3.986135,
      1,
      NULL,
      NULL,
      NULL,
      1.139138,
      0.987534,
      1.871826,
      3.076008,
      0.923604,
      3.646598,
      1,
      NULL,
      1.015030,
      0.945645,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.992185,
      1.664765,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.297611,
      7.832331,
      1,
      5.149251,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.041705,
      NULL,
      0.701767,
      1,
      1.106676,
      1.824219,
      0.203957,
      NULL,
      0.222881,
      0.443171,
      0.437543,
      0,
      1.701417,
      1.518032,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      0.156492,
      1,
      1.299911,
      1.843715,
      NULL,
      NULL,
      0.435155,
      NULL,
      NULL,
      NULL,
      NULL,
      1.264106,
      0.458513,
      NULL,
      1,
      0,
      2.686764,
      4,
      0,
      5,
      0.966371,
      NULL,
      5.805929,
      3.504315,
      NULL,
      0.177053,
      2,
      1,
      0,
      0.834433,
      3,
      1.969508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.146606,
      1.226434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.536992,
      NULL,
      9.602297,
      3.168405,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.848155,
      0,
      1.678207,
      NULL,
      0,
      NULL,
      0,
      0,
      1.079942,
      0.151839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.758192,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      0.432924,
      3.366210,
      3,
      0,
      1,
      1,
      NULL,
      3.795665,
      1,
      0.619521,
      0.050224,
      NULL,
      NULL,
      0,
      0,
      0,
      0.576714,
      1.322387,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '41141',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1.090033,
      NULL,
      '',
      '',
      2,
      2.661642,
      1.109680,
      1.516349,
      1.905472,
      2,
      3.182757,
      1,
      1.974346);
commit;
end;
/


