set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9712044';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4141',
      '44242430',
      59,
      88.513889,
      '1402101',
      102,
      4,
      1.578081,
      3,
      '342041',
      NULL,
      ' 4- 5-1998',
      39,
      13.656468,
      0.884908,
      NULL,
      1,
      NULL,
      0,
      0.769975,
      1,
      NULL,
      1,
      3.941299,
      1.565235,
      NULL,
      1.994585,
      0,
      1,
      0.520935,
      0.130592,
      1.024349,
      1,
      0,
      0.649807,
      0.985735,
      1.901049,
      1.035166,
      1.075376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.008287,
      0,
      0.341055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.565229,
      1.471005,
      NULL,
      0.802727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.165926,
      1,
      1.932158,
      1,
      1,
      NULL,
      0,
      1,
      1.213129,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      0.272331,
      NULL,
      1,
      NULL,
      0.246742,
      1.810689,
      1.248117,
      0.716996,
      1,
      0,
      NULL,
      2.212294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.215849,
      1,
      1.875728,
      2,
      NULL,
      NULL,
      NULL,
      0,
      7,
      0.875415,
      1,
      NULL,
      0.686741,
      0,
      NULL,
      NULL,
      NULL,
      9.219566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.014259,
      0,
      0,
      NULL,
      0,
      1,
      0.217262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.816159,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.495637,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.222796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504237,
      1.101171,
      1.563232,
      NULL,
      0,
      0.483120,
      NULL,
      1,
      1.983494,
      3,
      0.527926,
      0,
      1.717101,
      0.853925,
      1.233063,
      0.285821,
      0,
      0.919850,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.476834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.536067,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.595349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.829794,
      1.632420,
      0,
      NULL,
      1.651264,
      1,
      0,
      0,
      2,
      '12432',
      '14341',
      '23040',
      NULL,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      1.259546,
      NULL,
      0.920036,
      1,
      NULL,
      3.086008,
      1,
      1.154665,
      2.579292);
commit;
end;
/


