set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9405403';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-1-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      NULL,
      '3031440',
      36,
      2,
      0,
      0,
      '310040',
      3.063450,
      '11- 8-1994',
      44,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.719618,
      0.589981,
      0.557586,
      0.670938,
      1,
      1.364712,
      0,
      NULL,
      1.701249,
      0,
      NULL,
      NULL,
      0.971741,
      0.681620,
      1,
      NULL,
      0,
      1.625794,
      0.195860,
      0.432896,
      0.509772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      1,
      NULL,
      0.791255,
      1,
      0,
      1,
      0.823750,
      NULL,
      0.509997,
      1,
      NULL,
      0.367973,
      NULL,
      0,
      NULL,
      1,
      NULL,
      5.737162,
      1,
      NULL,
      2,
      1,
      0,
      0,
      1.818405,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.537601,
      0,
      1,
      NULL,
      1,
      0.685374,
      1.287854,
      1.753330,
      0,
      0.431145,
      0,
      1.634988,
      0.463377,
      1.143873,
      1,
      1,
      0.450798,
      1,
      0,
      NULL,
      0.905657,
      NULL,
      0,
      1.491385,
      NULL,
      NULL,
      1,
      NULL,
      1.883867,
      NULL,
      NULL,
      1.893083,
      0,
      0,
      1,
      1.128541,
      1,
      1.712844,
      1,
      1.495343,
      1,
      0,
      NULL,
      1,
      1,
      1,
      NULL,
      2,
      1.619547,
      NULL,
      NULL,
      0.025222,
      1.907561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.843720,
      0,
      1,
      0,
      1.231599,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.754721,
      NULL,
      NULL,
      NULL,
      NULL,
      1.003610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.198093,
      0,
      0.154775,
      1,
      NULL,
      1.539041,
      NULL,
      NULL,
      NULL,
      1.092687,
      1,
      1.403742,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.108031,
      0,
      1.687821,
      0.021332,
      1.292201,
      0,
      NULL,
      0,
      0.752623,
      1,
      0.299668,
      1.894750,
      NULL,
      0,
      NULL,
      1,
      0.550865,
      NULL,
      1.798488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '1414',
      '',
      '',
      1.830536,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


