set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9726580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-4-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '231',
      '42431130',
      66,
      48,
      '1104413',
      13.165188,
      5,
      1.484986,
      NULL,
      NULL,
      NULL,
      ' 6-14-1981',
      32.090770,
      49.718094,
      0,
      NULL,
      1.410953,
      0,
      1,
      0.012451,
      0.484017,
      0,
      3,
      NULL,
      0.428261,
      1,
      1,
      0,
      6.714889,
      1,
      1.958750,
      NULL,
      5,
      0.010112,
      2,
      4,
      NULL,
      4.305489,
      0,
      0,
      0.065429,
      NULL,
      4.486556,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      2,
      0,
      1,
      0.863577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.699381,
      1,
      1.107316,
      2.317806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.470142,
      4,
      0,
      1.823808,
      1,
      5,
      NULL,
      1.617442,
      0.257366,
      1,
      1.996615,
      1,
      0.368021,
      4,
      0,
      0,
      1.434968,
      1.545366,
      NULL,
      NULL,
      0,
      3.297872,
      2.520107,
      5.497349,
      5,
      2.991400,
      8,
      1.911779,
      NULL,
      8,
      NULL,
      5,
      9,
      2.771618,
      9.043963,
      1,
      0.769787,
      3.903403,
      5,
      0,
      NULL,
      7.644788,
      3,
      2.664469,
      4,
      3.755174,
      2.226981,
      4.631396,
      1.164723,
      1,
      NULL,
      NULL,
      0.653226,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.269445,
      NULL,
      NULL,
      1,
      NULL,
      0.292467,
      0.138569,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.933249,
      0,
      2.875505,
      0.733640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.577034,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3.638821,
      1,
      7.541892,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5,
      2,
      NULL,
      4,
      0,
      6.530811,
      0.362195,
      0.098959,
      1,
      NULL,
      2.346739,
      1.688265,
      2,
      1.858214,
      0,
      3,
      1.846640,
      0,
      2.425972,
      0.666072,
      0.643832,
      0,
      0.058979,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.016512,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '01200',
      '34432',
      '10230',
      1,
      NULL,
      '',
      '',
      1.063695,
      '22434',
      '1431',
      '',
      1,
      3,
      6,
      0.866288,
      4,
      6,
      4.748234,
      NULL,
      2);
commit;
end;
/


