set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9726580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '032',
      '41444030',
      49.553267,
      74,
      NULL,
      NULL,
      4,
      1.775043,
      NULL,
      NULL,
      5.347183,
      ' 6-15-1995',
      NULL,
      29,
      1.342791,
      NULL,
      1,
      0.700427,
      1.926256,
      0,
      0.588658,
      0.353546,
      NULL,
      NULL,
      NULL,
      1.209810,
      1.106119,
      1,
      4.640901,
      NULL,
      2,
      0.259254,
      2,
      0,
      0,
      5.610932,
      NULL,
      1,
      4,
      0,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      4.075013,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.041193,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      1,
      3.318892,
      0.760777,
      NULL,
      NULL,
      1.897243,
      1,
      0,
      4,
      0,
      0,
      0,
      1.621850,
      NULL,
      NULL,
      1.254683,
      NULL,
      3,
      2.721522,
      6,
      1.246748,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.679273,
      0.967643,
      1,
      1.495146,
      9.305044,
      3,
      2,
      NULL,
      1.095972,
      11,
      2,
      7.561403,
      0.094814,
      NULL,
      3.725043,
      2,
      0.819587,
      NULL,
      4.693355,
      1.161247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.192675,
      1,
      0,
      0,
      NULL,
      1,
      0.634245,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5.123426,
      1.473807,
      1.321219,
      0.451433,
      0.045531,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.101064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      5.099551,
      7.350508,
      2,
      1.708617,
      NULL,
      NULL,
      NULL,
      0,
      8.315596,
      1,
      3.081478,
      4,
      NULL,
      3.838227,
      1.135540,
      0,
      1.165512,
      0,
      3.375385,
      0.127527,
      3,
      NULL,
      1,
      1,
      NULL,
      0.503464,
      1,
      1.617695,
      NULL,
      0.626662,
      1,
      NULL,
      0,
      1,
      1,
      1.249334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '42222',
      '21202',
      '24120',
      1,
      '',
      '',
      '',
      5,
      '00243',
      '3040',
      '',
      0,
      1.919151,
      1.480046,
      2,
      3,
      NULL,
      NULL,
      3,
      NULL);
commit;
end;
/


