set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9726580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '03031331',
      10,
      NULL,
      '4433342',
      NULL,
      5,
      1,
      1,
      '424213',
      0,
      ' 4-22-1981',
      27.245630,
      NULL,
      0,
      NULL,
      NULL,
      1.869340,
      3.325841,
      1.205274,
      0,
      NULL,
      1,
      0.131857,
      1,
      1,
      NULL,
      1,
      1.441146,
      4,
      NULL,
      NULL,
      7.040073,
      0.489648,
      7,
      1.597893,
      0.028491,
      NULL,
      1,
      0,
      0.911066,
      1,
      0.433680,
      1.065990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.058269,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.395600,
      1.722319,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.705970,
      NULL,
      1,
      1.952725,
      0,
      1,
      3,
      NULL,
      0,
      0,
      1,
      0.416937,
      0,
      3,
      0.443654,
      1.992186,
      1,
      0,
      NULL,
      NULL,
      0,
      6,
      3.928677,
      NULL,
      5,
      1,
      8.418800,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.863242,
      6.418253,
      0.387251,
      0,
      4.660302,
      1.827668,
      0.957085,
      5.501379,
      2,
      8.560616,
      4.556193,
      1.558297,
      3.699843,
      NULL,
      0,
      1.180274,
      1.500298,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.576568,
      1,
      0,
      0,
      0,
      1.309220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.410117,
      NULL,
      2,
      3.339500,
      3,
      3,
      1.084032,
      NULL,
      1.675305,
      0,
      NULL,
      7.656230,
      2.853782,
      1.522118,
      NULL,
      NULL,
      NULL,
      1.574757,
      2.243641,
      4.060074,
      1,
      2.368500,
      NULL,
      2.540111,
      NULL,
      NULL,
      NULL,
      1.458678,
      4,
      0.036256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.786738,
      2,
      3,
      0,
      3,
      NULL,
      2,
      3.345857,
      1,
      1,
      1.591313,
      0,
      1,
      0.081370,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '40133',
      NULL,
      '23343',
      0.367671,
      '',
      NULL,
      '',
      6.973702,
      '40000',
      '44140',
      '2442',
      3.876026,
      3.247263,
      NULL,
      2.738117,
      5,
      0,
      1,
      3,
      3);
commit;
end;
/


