set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9726580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3140',
      '20443104',
      14.471195,
      NULL,
      '3312022',
      29.164437,
      0,
      3.992991,
      2,
      '412133',
      2,
      NULL,
      63,
      NULL,
      1.554652,
      NULL,
      1.965672,
      0.790047,
      0,
      0,
      NULL,
      0,
      2,
      3.371578,
      0,
      1.537269,
      3.905306,
      1,
      NULL,
      NULL,
      1.465175,
      0,
      3,
      1,
      NULL,
      NULL,
      0.443476,
      0,
      0.925737,
      NULL,
      NULL,
      0,
      1.367869,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.368201,
      0.695347,
      1.136484,
      0.963372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.536812,
      0,
      0.081697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.751540,
      NULL,
      0.519177,
      NULL,
      1.030765,
      0.549294,
      NULL,
      0.562776,
      1.350914,
      0,
      1.743915,
      1.036836,
      NULL,
      3,
      1.684802,
      0.403123,
      0.912081,
      0,
      1.836950,
      NULL,
      0.010348,
      6.196270,
      0.688664,
      0,
      2.908870,
      1,
      5,
      0.328904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      5,
      1,
      3.301082,
      NULL,
      2,
      0.366087,
      3.789811,
      2.786949,
      2,
      10,
      0.761334,
      1,
      2.466250,
      1,
      NULL,
      1,
      1,
      3,
      1.983858,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.565516,
      1.370869,
      0,
      0,
      1,
      NULL,
      NULL,
      0.587469,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.209304,
      3.869688,
      NULL,
      0.421822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.614078,
      NULL,
      1.424550,
      NULL,
      0,
      0.792475,
      NULL,
      NULL,
      NULL,
      1.875658,
      2.911753,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.643719,
      2.289714,
      3,
      0,
      NULL,
      0,
      0.900201,
      0.940017,
      0,
      2,
      NULL,
      0.331779,
      1.549328,
      1,
      NULL,
      NULL,
      0,
      0.672174,
      1.480640,
      0.414321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      '44102',
      NULL,
      '40220',
      1.709046,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '41044',
      '0340',
      2,
      5,
      NULL,
      0.637125,
      0,
      1,
      0.619883,
      1.866859,
      2);
commit;
end;
/


