set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9424759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-1-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '303',
      '11010413',
      42,
      NULL,
      '1200200',
      14,
      4,
      0.947502,
      1,
      '423211',
      4.331925,
      ' 4-10-2000',
      17.660549,
      27.272358,
      1,
      NULL,
      2,
      1,
      3,
      NULL,
      2,
      1,
      0.605141,
      0.735164,
      1.355879,
      1.059552,
      3,
      1.915763,
      0.314887,
      1,
      1,
      0.211066,
      NULL,
      1,
      1,
      0,
      0.831608,
      0,
      NULL,
      0,
      1.297254,
      1,
      0,
      0.630461,
      NULL,
      NULL,
      0.737874,
      NULL,
      NULL,
      3,
      1.111137,
      1.787737,
      1.695823,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.782510,
      1.637130,
      1.558566,
      3.059711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.317816,
      1.280027,
      0.271513,
      0,
      0.680585,
      4,
      0.704382,
      NULL,
      1,
      3.591350,
      0.442109,
      1,
      0,
      2,
      1,
      1,
      0,
      0,
      1,
      NULL,
      0,
      0.776512,
      2,
      NULL,
      NULL,
      1,
      3.259662,
      NULL,
      NULL,
      NULL,
      1.203456,
      NULL,
      0,
      1,
      1.763961,
      0,
      3.332943,
      NULL,
      NULL,
      5.317104,
      3.508835,
      NULL,
      NULL,
      0.783950,
      NULL,
      5.272926,
      1.223182,
      0.910221,
      0,
      NULL,
      NULL,
      NULL,
      0.061775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.521036,
      0,
      0,
      NULL,
      1,
      0.892717,
      1.837374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.444824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.825715,
      NULL,
      0,
      NULL,
      3,
      6,
      NULL,
      0.017790,
      NULL,
      NULL,
      NULL,
      5.631979,
      0.183969,
      0.163585,
      1.438318,
      0,
      NULL,
      0.390427,
      NULL,
      NULL,
      NULL,
      0.825613,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.583108,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      3,
      0,
      0,
      0.754906,
      1,
      0.196309,
      NULL,
      1.570275,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.700904,
      1.871852,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.924277,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.214909,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254819,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.887319,
      0,
      NULL,
      0,
      0,
      0.823009,
      2,
      3.015862,
      '24010',
      NULL,
      NULL,
      1.291290,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      2.194393,
      3.919830,
      2.195150,
      3,
      3.646357,
      2.661119,
      1.674009);
commit;
end;
/


