set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9424759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-6-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '31433014',
      NULL,
      30.984633,
      '1214312',
      4.997878,
      2,
      2,
      2,
      '112404',
      NULL,
      ' 0- 1-1997',
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.688969,
      0.942697,
      0.721568,
      0,
      2,
      NULL,
      1.080946,
      1.004582,
      1,
      0.670000,
      0.024620,
      1.610190,
      0,
      1,
      0.755281,
      NULL,
      0.231362,
      5.583860,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.087044,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.012352,
      NULL,
      0.569750,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.320650,
      NULL,
      4,
      0,
      3.496379,
      5.497457,
      NULL,
      0,
      0,
      0,
      1,
      1.586303,
      1.110129,
      7.984049,
      1,
      0.131758,
      0.949129,
      NULL,
      1.466395,
      NULL,
      NULL,
      1,
      3,
      1.775004,
      1.087132,
      0.083728,
      5.805873,
      1.775431,
      1,
      0,
      1.926966,
      NULL,
      1.070714,
      0,
      NULL,
      1.285769,
      0,
      5,
      3.238177,
      3,
      9,
      6,
      9.781280,
      4.545146,
      6,
      NULL,
      0,
      1,
      2.179412,
      1,
      1.609091,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      1.016679,
      0.341088,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.845403,
      0.368965,
      1,
      0.700130,
      3,
      3.409625,
      3.023332,
      1,
      NULL,
      NULL,
      NULL,
      1,
      3.071678,
      NULL,
      1,
      NULL,
      NULL,
      0.155372,
      0,
      NULL,
      NULL,
      1,
      1.794061,
      1.207808,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.105628,
      NULL,
      0,
      1,
      1,
      NULL,
      3.132793,
      0,
      3,
      2,
      1.802997,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      0.418978,
      0.988627,
      0.332310,
      0,
      NULL,
      2.501269,
      3.973616,
      NULL,
      3,
      0,
      0,
      1,
      1,
      0,
      1,
      0.947928,
      0,
      1.899032,
      1.358151,
      0.978475,
      0,
      1,
      3,
      NULL,
      0,
      1.742739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.687140,
      NULL,
      1.464271,
      0.359696,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.833014,
      NULL,
      NULL,
      NULL,
      NULL,
      3.045928,
      1.385102,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      '31020',
      NULL,
      NULL,
      0.466462,
      '',
      '',
      '',
      0.841817,
      '',
      '',
      '',
      0,
      4.938705,
      7,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1);
commit;
end;
/


