set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9424759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '430',
      '04111120',
      NULL,
      46,
      '1134233',
      12,
      4,
      2,
      3,
      '013441',
      2.792652,
      NULL,
      34,
      198,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      0,
      1.844114,
      3.985430,
      0.927441,
      0.925698,
      3.813054,
      0,
      3.793427,
      0,
      NULL,
      NULL,
      2.754206,
      0.484888,
      1,
      1,
      NULL,
      0.235963,
      2,
      0,
      0,
      1.487246,
      2.936843,
      1,
      NULL,
      NULL,
      0.355833,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.403050,
      5.593683,
      1,
      3.718870,
      NULL,
      1,
      0,
      0.219657,
      NULL,
      NULL,
      1.152585,
      NULL,
      NULL,
      1.040320,
      5,
      1.684248,
      0.546256,
      4.779829,
      NULL,
      7,
      0,
      1,
      NULL,
      1.256807,
      1,
      1.498567,
      NULL,
      0,
      0.125904,
      1,
      0,
      1,
      NULL,
      1.854026,
      1,
      2.320598,
      0.607876,
      NULL,
      NULL,
      5.966457,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      7.819436,
      NULL,
      NULL,
      6.409495,
      9.202917,
      NULL,
      10,
      8,
      NULL,
      5,
      NULL,
      0.155784,
      2,
      1.659082,
      1,
      1,
      2.277399,
      0.430378,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.014294,
      1,
      0,
      0,
      0.284191,
      0.690756,
      1.572873,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.286964,
      1.093969,
      1,
      4,
      7,
      1.141845,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.502149,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.980359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      0,
      NULL,
      0.131727,
      0,
      1,
      0,
      0,
      1.370625,
      NULL,
      3.672205,
      0.854555,
      1,
      1,
      0.798599,
      0.538972,
      1.590497,
      NULL,
      2.808610,
      1.578783,
      0,
      1,
      NULL,
      1.803596,
      NULL,
      1.988294,
      1.401016,
      1,
      0.736631,
      1.416270,
      1.265765,
      0,
      NULL,
      1,
      0.046166,
      1.072570,
      1,
      0,
      0,
      1.847955,
      0.184312,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.567011,
      NULL,
      '02222',
      NULL,
      0.224074,
      '',
      '',
      '',
      1,
      NULL,
      '',
      '',
      2,
      4,
      6.231465,
      2.811356,
      5,
      NULL,
      3,
      3.757597,
      1);
commit;
end;
/


