set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9424759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '30114423',
      NULL,
      1.127522,
      '3230110',
      31,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      215,
      0.444887,
      NULL,
      NULL,
      1.204932,
      3,
      NULL,
      0.797593,
      1,
      NULL,
      1.357543,
      0,
      0,
      8,
      0,
      7,
      3,
      1.278286,
      NULL,
      7.690280,
      0.933461,
      NULL,
      NULL,
      NULL,
      0,
      6.199595,
      0,
      1.821717,
      1,
      0.781820,
      0,
      NULL,
      NULL,
      0.165241,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.985336,
      1.046708,
      1.585432,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      1,
      5.320908,
      2.545026,
      NULL,
      1,
      2,
      3,
      0,
      NULL,
      0.249077,
      3,
      1.593703,
      0,
      NULL,
      0,
      1.111619,
      NULL,
      1.599146,
      3.069397,
      3.964522,
      3.710194,
      7,
      0.295620,
      0.133487,
      1.378673,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.950849,
      0,
      2,
      1,
      8,
      0.358149,
      NULL,
      0.571960,
      6.889637,
      4,
      NULL,
      2,
      1.808762,
      NULL,
      5.653543,
      NULL,
      0,
      1.178602,
      5.819805,
      1.970121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.218969,
      1,
      0,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      1,
      2,
      0.974182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.798936,
      2,
      0,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      7,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.789793,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.285429,
      2.165555,
      3,
      2.782724,
      0,
      0,
      2.667325,
      2,
      NULL,
      1,
      1.038707,
      NULL,
      1,
      NULL,
      1.018605,
      1,
      3,
      1.627687,
      1.211159,
      1.755977,
      2.439343,
      2,
      1.703179,
      1.577852,
      NULL,
      1,
      0,
      0.057949,
      0,
      0.342653,
      NULL,
      0.054361,
      1.074830,
      0,
      NULL,
      1.539852,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '04034',
      '43024',
      '',
      NULL,
      '',
      NULL,
      '',
      0.501081,
      '',
      NULL,
      '',
      3.539227,
      4.633737,
      1,
      0,
      0,
      3,
      0,
      0,
      NULL);
commit;
end;
/


