set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9424759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '14034232',
      NULL,
      NULL,
      '4331434',
      68.303266,
      1,
      3,
      2,
      '134434',
      4.633939,
      ' 4-26-2003',
      NULL,
      26.303931,
      0,
      NULL,
      0,
      1,
      0.179048,
      1,
      NULL,
      2,
      0,
      NULL,
      1.814952,
      1,
      0,
      NULL,
      5,
      8,
      0,
      1.143055,
      8,
      0,
      1.772829,
      1.270350,
      0.773310,
      NULL,
      NULL,
      0,
      0.235647,
      3,
      1,
      0.760227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.490849,
      1.569708,
      0.753409,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.084535,
      1,
      0.341800,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.399368,
      7,
      5,
      NULL,
      7,
      NULL,
      4.016144,
      0,
      0,
      2,
      0,
      1,
      0,
      4.929943,
      NULL,
      1,
      0.774300,
      1.556503,
      0.188030,
      NULL,
      1.000971,
      3,
      5.732366,
      4,
      5.471572,
      0,
      7,
      NULL,
      0,
      0.249653,
      NULL,
      4,
      1,
      5,
      4.855853,
      1.626179,
      NULL,
      NULL,
      9.937726,
      5.792659,
      7,
      3.472578,
      7,
      10,
      9.631958,
      2,
      0.846351,
      0,
      3.918888,
      NULL,
      0.504339,
      3,
      1.183792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.404397,
      0,
      1,
      NULL,
      1,
      1,
      1.565326,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.175318,
      NULL,
      NULL,
      1.984864,
      1.149522,
      1.566899,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.232904,
      NULL,
      NULL,
      0.946583,
      0,
      1.304557,
      NULL,
      NULL,
      NULL,
      0,
      4,
      1.683653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.495085,
      0.184555,
      0,
      0.232776,
      0,
      3.055617,
      1.539008,
      3.147293,
      NULL,
      3,
      0.135651,
      3.449539,
      NULL,
      1,
      1,
      0.039700,
      1,
      NULL,
      0,
      1.950038,
      1,
      0,
      1,
      2,
      3,
      1.729115,
      1.327596,
      1.197880,
      1,
      1,
      NULL,
      1.757770,
      1,
      1.855631,
      0.380757,
      1.488369,
      0.495379,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '32324',
      '33402',
      '',
      0,
      '',
      NULL,
      '',
      0.283741,
      '',
      '',
      '',
      NULL,
      0.745934,
      1,
      1.846828,
      1,
      0,
      0,
      2,
      3);
commit;
end;
/


