set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9424759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '344',
      '04331023',
      49,
      56.731572,
      '3432203',
      40.805679,
      NULL,
      NULL,
      2,
      '240140',
      6.102255,
      ' 0-11-1976',
      50,
      5.111109,
      0,
      NULL,
      3.426417,
      1,
      NULL,
      0,
      NULL,
      2,
      1,
      NULL,
      1.524014,
      0,
      NULL,
      0.729362,
      NULL,
      0,
      0.122952,
      1.990349,
      8.877858,
      NULL,
      NULL,
      0.501186,
      0,
      1.299810,
      9.663292,
      1,
      2,
      NULL,
      0.780920,
      0,
      NULL,
      NULL,
      0.277205,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.762724,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.844760,
      0.456550,
      NULL,
      1.810712,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1.219776,
      2.610395,
      7,
      6.415880,
      0.267858,
      0,
      1.549179,
      0,
      0,
      1,
      1.226671,
      1.750197,
      1,
      1,
      0,
      0.311253,
      NULL,
      0,
      5,
      3.946688,
      3.826302,
      2,
      1,
      5,
      0.354009,
      1,
      0.802287,
      1.837778,
      1,
      1.957736,
      NULL,
      1,
      3.271297,
      3.585824,
      1.207581,
      3.633331,
      9.978432,
      6,
      NULL,
      6.760324,
      3,
      2,
      2,
      NULL,
      2.163270,
      NULL,
      1,
      NULL,
      0,
      1.713087,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.051402,
      0.698024,
      2,
      0,
      NULL,
      NULL,
      3,
      0.421984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.926328,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.964176,
      NULL,
      1.529022,
      0,
      0.000032,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.908427,
      2.652740,
      0,
      2.225863,
      2,
      0.608233,
      1,
      1,
      3.093890,
      0.109509,
      NULL,
      0.519569,
      0,
      3.961694,
      0,
      NULL,
      1.869802,
      NULL,
      3,
      0.448510,
      NULL,
      1.695121,
      0,
      3,
      3,
      2,
      0.337858,
      NULL,
      1.896113,
      1,
      1,
      1,
      1,
      0,
      0.918955,
      NULL,
      1,
      1,
      1.799189,
      NULL,
      0,
      1.555830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '23024',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0.220232,
      '',
      '',
      '',
      2.365044,
      1,
      2.399184,
      3,
      4,
      NULL,
      1,
      1,
      1);
commit;
end;
/


