set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9424759';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-7-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '11204312',
      58,
      30.021200,
      NULL,
      119.882561,
      6,
      1.935875,
      3,
      '220311',
      5.209513,
      ' 1-27-1984',
      NULL,
      48.738792,
      1,
      NULL,
      NULL,
      NULL,
      1.646207,
      NULL,
      1,
      1,
      0,
      NULL,
      1.001534,
      NULL,
      3,
      0,
      5,
      3,
      3,
      5,
      7,
      1.798262,
      NULL,
      1.420227,
      1,
      0.616513,
      1,
      1,
      5.713231,
      1.749435,
      0,
      0.237852,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.154792,
      1.895070,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.767988,
      0.225447,
      NULL,
      1.856040,
      3.428996,
      NULL,
      7.009386,
      NULL,
      0,
      NULL,
      0.297576,
      NULL,
      1,
      1.497214,
      0.162454,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      2.571813,
      NULL,
      5.675883,
      5,
      0,
      0,
      NULL,
      0.229986,
      1.439900,
      0,
      3.466715,
      1.319402,
      3,
      3.123787,
      4,
      6,
      7.194157,
      3,
      3.950705,
      1,
      9.892822,
      NULL,
      0.196047,
      1,
      NULL,
      0,
      2,
      NULL,
      1,
      2.367089,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.610139,
      0,
      NULL,
      1,
      1.544394,
      NULL,
      0.413775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.160505,
      1,
      NULL,
      0.582861,
      NULL,
      NULL,
      0,
      NULL,
      9,
      0.057999,
      0.634083,
      NULL,
      NULL,
      NULL,
      5,
      1.071551,
      6.848876,
      3.563832,
      2,
      1,
      3,
      NULL,
      NULL,
      NULL,
      1.895676,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.949014,
      3,
      0,
      1,
      0,
      NULL,
      2.282868,
      1,
      0,
      0.477123,
      NULL,
      0.412161,
      1,
      1,
      1.577740,
      0,
      1.053858,
      1.984608,
      1.116422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.936359,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.887782,
      '24404',
      NULL,
      '',
      1.306788,
      NULL,
      '',
      '',
      0.845529,
      '',
      '',
      '',
      3,
      2,
      NULL,
      3.036687,
      1.756306,
      1.879763,
      0,
      0.122678,
      NULL);
commit;
end;
/


