set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923682';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-1-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      NULL,
      '3401202',
      9,
      2,
      1.493583,
      2,
      '034334',
      2.512885,
      ' 6-15-1975',
      17.312517,
      NULL,
      0.029999,
      NULL,
      NULL,
      1.888617,
      0,
      1.313308,
      NULL,
      3.177325,
      1,
      1.207232,
      NULL,
      0,
      3,
      0.405390,
      NULL,
      1.506671,
      2,
      0,
      8,
      1.134845,
      0.227489,
      1,
      1,
      0,
      2.465804,
      0,
      NULL,
      1.930914,
      1,
      0.923829,
      NULL,
      NULL,
      0.336377,
      NULL,
      NULL,
      1.188522,
      1,
      NULL,
      0.091519,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.512453,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.635173,
      2.367429,
      NULL,
      2,
      1,
      0.664876,
      NULL,
      NULL,
      1.090888,
      0.270971,
      0,
      0,
      0.789269,
      0.040249,
      0.380326,
      1,
      1,
      NULL,
      NULL,
      1,
      5,
      0.662716,
      1.988560,
      2.112852,
      1.336296,
      3.468607,
      0.189944,
      6.665107,
      0.469987,
      NULL,
      8,
      NULL,
      1,
      NULL,
      1.230619,
      3,
      6.073530,
      9,
      NULL,
      6.627439,
      6.643959,
      0.356268,
      11.841908,
      5.070618,
      0,
      0.928637,
      1.350370,
      2.574487,
      0,
      1,
      3,
      1.454869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.566526,
      1.476765,
      NULL,
      1,
      0,
      4,
      0.719733,
      0.464551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.657936,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      3,
      1,
      0.310776,
      3.649912,
      5,
      2.408043,
      1.775636,
      NULL,
      NULL,
      NULL,
      3,
      1.888397,
      4,
      2.100647,
      0.129230,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.190279,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.977603,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.696296,
      2.096725,
      NULL,
      2.711308,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.726076,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.389265,
      '24401',
      '',
      '',
      0,
      '',
      '',
      '',
      2,
      '1134',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


