set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923682';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-3-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      '1411204',
      90.569768,
      0,
      2,
      0,
      NULL,
      1.693577,
      ' 4-16-2000',
      19.874898,
      NULL,
      0.829558,
      NULL,
      0,
      0,
      0.445854,
      1,
      1.217113,
      3.274817,
      1,
      1.350040,
      1.342770,
      1,
      3,
      1,
      0,
      NULL,
      0.313077,
      NULL,
      NULL,
      1,
      1.247422,
      0.664359,
      0.265330,
      0.821065,
      1.641586,
      1,
      1.984453,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.798050,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.421737,
      0.815019,
      1,
      1.685244,
      0.545118,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.609207,
      0,
      0.958162,
      0,
      1.847177,
      NULL,
      0,
      NULL,
      0.738216,
      1.327412,
      1,
      0,
      1,
      NULL,
      2,
      NULL,
      5.924096,
      0.931099,
      NULL,
      0.786269,
      0,
      0,
      3,
      1,
      3.660492,
      3.592062,
      NULL,
      2.898272,
      NULL,
      7.012725,
      0,
      11.448327,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7,
      0.528855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.119037,
      1,
      1,
      0,
      0.943513,
      0.673258,
      0.220441,
      0.203904,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.915783,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0.681361,
      0,
      1.593976,
      NULL,
      3.067261,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.926186,
      1,
      1,
      0.001412,
      0,
      1,
      1.144805,
      NULL,
      NULL,
      NULL,
      NULL,
      3.274460,
      1.342944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.372253,
      3.941611,
      0,
      1.979218,
      3,
      2.894067,
      3,
      0.112862,
      0.688661,
      1.036872,
      0,
      1,
      NULL,
      0,
      0,
      1,
      1.521760,
      0.060230,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.273249,
      '33444',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0.082830,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


