set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923682';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-9-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '132',
      '14',
      2.345079,
      10,
      '0013214',
      185,
      2,
      NULL,
      1,
      '113114',
      1.110251,
      ' 6- 6-1980',
      NULL,
      65.184923,
      NULL,
      NULL,
      0,
      0,
      2.029394,
      NULL,
      1,
      NULL,
      NULL,
      0.246520,
      3.248916,
      0,
      6,
      1,
      0.513428,
      0.177116,
      0,
      NULL,
      4.990712,
      1.651908,
      NULL,
      1.930354,
      1,
      0,
      6.768521,
      0,
      NULL,
      1.337019,
      0.336424,
      1.316045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.327184,
      NULL,
      1,
      3.106757,
      1.141875,
      NULL,
      0.969504,
      0,
      0,
      2.846086,
      1.207971,
      0,
      1.995558,
      NULL,
      0.670706,
      2.378065,
      NULL,
      1.997533,
      1.200450,
      1.403434,
      1,
      0,
      NULL,
      1,
      0,
      NULL,
      1.533768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.863829,
      NULL,
      NULL,
      1.007937,
      1.320588,
      1,
      1.997036,
      NULL,
      0.346698,
      1.611836,
      NULL,
      NULL,
      0.724065,
      1,
      0,
      1.046260,
      1.722739,
      1.934534,
      NULL,
      0,
      6,
      NULL,
      1.234566,
      0.691747,
      NULL,
      5,
      0,
      1.188190,
      1,
      1.822704,
      NULL,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      6.531774,
      NULL,
      6,
      0.065119,
      NULL,
      2.433376,
      1.124136,
      0,
      NULL,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.305522,
      0,
      NULL,
      NULL,
      1.343260,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.278538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.040261,
      2,
      0.583609,
      NULL,
      NULL,
      NULL,
      5.456195,
      1,
      1,
      0,
      0,
      NULL,
      1.882012,
      NULL,
      NULL,
      NULL,
      1.664224,
      2.546835,
      1.057720,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.866837,
      NULL,
      2.489572,
      1,
      2.907447,
      0.887644,
      0,
      1,
      1.753631,
      0,
      1.960596,
      1.379890,
      NULL,
      0.492762,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.032876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      '12222',
      '',
      '',
      1,
      '',
      '',
      '',
      3.223729,
      '4314',
      '',
      NULL,
      1.191933,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


