set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923682';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-3-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '332',
      '33',
      52.779603,
      43.187346,
      '0211121',
      111.617676,
      6,
      2.162798,
      1,
      '212034',
      3.583407,
      NULL,
      31,
      NULL,
      1.616487,
      NULL,
      2,
      1.913025,
      3.857073,
      1,
      1.219066,
      3,
      3,
      0,
      2.537298,
      1.059354,
      4,
      1,
      NULL,
      1.804882,
      1.198012,
      NULL,
      1.479705,
      0.605853,
      0,
      0.998718,
      0,
      NULL,
      5.440530,
      0,
      2.443546,
      1.991037,
      1,
      0,
      NULL,
      NULL,
      0.701104,
      NULL,
      NULL,
      1.983445,
      1.933632,
      0.253376,
      0.985748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.210222,
      NULL,
      1,
      1,
      1.097763,
      0,
      0.511763,
      1.147664,
      NULL,
      1,
      1,
      0.686142,
      1,
      0.851973,
      1,
      NULL,
      1,
      3.446703,
      1.701211,
      1,
      NULL,
      1.894157,
      4.601752,
      0,
      3,
      0.497333,
      4.778517,
      1.070237,
      0.375370,
      0,
      0,
      0.247629,
      NULL,
      2,
      NULL,
      9,
      4,
      NULL,
      0,
      10,
      9.318866,
      0.004906,
      NULL,
      0.809513,
      3,
      1.944741,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.102427,
      1.807228,
      0,
      1,
      0,
      0,
      0.849966,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.642735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.981327,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.005342,
      0,
      0.243230,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.459679,
      0.917272,
      1.044177,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.240444,
      NULL,
      NULL,
      2.644893,
      0,
      0.217768,
      0.955559,
      1,
      3,
      0.664548,
      0.406042,
      0.060671,
      1.661058,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.542269,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.425512,
      '21404',
      '',
      '',
      1,
      '',
      NULL,
      '',
      NULL,
      '0404',
      '',
      NULL,
      4.927243,
      0,
      2.862260,
      NULL,
      0.389309,
      0.285048,
      0,
      3.171594,
      3);
commit;
end;
/


