set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923682';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-2-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '122',
      '32024401',
      NULL,
      14.592989,
      '0203404',
      146.106791,
      2,
      0,
      3,
      '031122',
      0.764113,
      ' 9-28-1975',
      38.987306,
      20.285676,
      0,
      NULL,
      2,
      1,
      3,
      0,
      NULL,
      0,
      0.635489,
      1,
      1.055248,
      0,
      NULL,
      0,
      0.440573,
      1.198630,
      1.556331,
      0.935973,
      4,
      0,
      0.209331,
      NULL,
      NULL,
      1.967486,
      0,
      1,
      4.771699,
      0.637508,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.603984,
      0.663933,
      0.697911,
      1.937837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.567660,
      NULL,
      1,
      1.414109,
      0.571945,
      1.977315,
      0.813046,
      NULL,
      NULL,
      1,
      NULL,
      1.512851,
      1,
      1.162389,
      NULL,
      1.452631,
      0.788646,
      1,
      1.347308,
      NULL,
      NULL,
      0,
      3.646038,
      0,
      0,
      NULL,
      3,
      1.299745,
      3.793347,
      0.549808,
      3,
      1.741879,
      0,
      1,
      5,
      0.276592,
      0,
      NULL,
      0.299304,
      NULL,
      0.031186,
      0,
      NULL,
      7.554411,
      5.148782,
      0.833410,
      NULL,
      NULL,
      2.122942,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.451497,
      0,
      0.911655,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.106974,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      0,
      NULL,
      1.958309,
      0.311978,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.672174,
      NULL,
      1.373102,
      1.842719,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1.368717,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.824465,
      NULL,
      NULL,
      2.634461,
      0.503320,
      0.511420,
      0,
      0.007467,
      2.790438,
      NULL,
      NULL,
      NULL,
      0,
      0.107878,
      0,
      1,
      1.789706,
      0.199616,
      0.561072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      '10232',
      '',
      NULL,
      1.200649,
      '',
      '',
      '',
      2.693071,
      NULL,
      '',
      '',
      4,
      3,
      NULL,
      NULL,
      NULL,
      3.059057,
      NULL,
      0.148618,
      3);
commit;
end;
/


