set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923682';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-8-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '401',
      '20442043',
      0.981224,
      4,
      '0210141',
      172.109987,
      6,
      0,
      1,
      '003210',
      5,
      '11-25-1994',
      25,
      56.009319,
      NULL,
      NULL,
      0,
      NULL,
      1.409086,
      NULL,
      1,
      NULL,
      1.815212,
      0.472009,
      0.544302,
      0.438513,
      6,
      1.499431,
      0.803432,
      NULL,
      0,
      NULL,
      3.982145,
      1,
      NULL,
      0.114084,
      1,
      0,
      7.037244,
      0,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.345713,
      1.383643,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      1.059727,
      1,
      1.675740,
      0,
      NULL,
      1,
      0.170010,
      1,
      1,
      0.532372,
      1,
      0,
      1.807960,
      0.101712,
      1.193397,
      NULL,
      1.987607,
      4,
      0,
      1,
      NULL,
      0.928479,
      NULL,
      0,
      2,
      0.794423,
      1,
      0,
      1.994361,
      0,
      4.369115,
      1.611933,
      3,
      4.048285,
      0.508621,
      5.022193,
      2,
      NULL,
      NULL,
      3.311195,
      9.541381,
      0,
      1.858350,
      NULL,
      1.829354,
      NULL,
      1,
      7.823165,
      0.353375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.525966,
      NULL,
      0,
      1.063953,
      0,
      0.080720,
      0.883984,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.805674,
      3.439318,
      1.725991,
      0,
      1.601885,
      1.766372,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.664463,
      0,
      0,
      1,
      1.568426,
      0,
      1.295823,
      NULL,
      NULL,
      NULL,
      0.907344,
      NULL,
      1.388357,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.874864,
      2.345794,
      2.681426,
      NULL,
      3.110405,
      1,
      2,
      2.705413,
      NULL,
      1,
      1.160705,
      1,
      0.288692,
      1,
      0,
      0.208085,
      1.560461,
      1.998030,
      0.954614,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.936502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      0,
      NULL,
      NULL,
      '',
      0,
      2,
      2,
      3.102136,
      0,
      1,
      NULL,
      2.052991,
      2);
commit;
end;
/


