set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923682';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '311',
      '12131103',
      29.630925,
      58,
      '0124441',
      306.165378,
      1,
      NULL,
      NULL,
      '000344',
      NULL,
      ' 2- 0-1996',
      40.231483,
      17.178509,
      0.961440,
      NULL,
      3,
      NULL,
      0.123861,
      1,
      0.061330,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1.957621,
      NULL,
      0.156134,
      NULL,
      0.598598,
      NULL,
      0.118875,
      1,
      1,
      0,
      1,
      5,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.971601,
      NULL,
      NULL,
      0,
      1.298311,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.411299,
      1,
      0.908497,
      1.095023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.284475,
      0.841745,
      3,
      5.049387,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.510209,
      1,
      0.849501,
      0.272801,
      0.680801,
      1,
      NULL,
      0.242033,
      0,
      NULL,
      1,
      3,
      1,
      0.017144,
      1,
      1,
      0.779847,
      0.899084,
      0.653655,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      4.591367,
      1.814759,
      NULL,
      7,
      1.368885,
      2,
      1,
      4,
      NULL,
      1.221152,
      NULL,
      0.009336,
      NULL,
      NULL,
      NULL,
      1.302172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.548550,
      1.327765,
      NULL,
      NULL,
      0,
      1.803618,
      1,
      1.157138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.712919,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.904725,
      1.404821,
      NULL,
      NULL,
      NULL,
      0,
      1.600078,
      1,
      4,
      1,
      0,
      1.580074,
      NULL,
      NULL,
      NULL,
      1.032532,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.718970,
      NULL,
      0,
      NULL,
      1,
      0.242434,
      1.076268,
      1.118795,
      0.729976,
      1,
      0.993844,
      1.546783,
      1.607207,
      0.939582,
      0.819171,
      1.884870,
      0.777462,
      1,
      0,
      0.550957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '24213',
      '',
      NULL,
      1.759320,
      '',
      NULL,
      '',
      3,
      NULL,
      '2103',
      NULL,
      3.861585,
      NULL,
      NULL,
      NULL,
      3.094252,
      1.890544,
      0,
      3.684359,
      2.026237);
commit;
end;
/


