set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923682';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '313',
      NULL,
      11,
      66,
      NULL,
      26.514094,
      2,
      0.107301,
      NULL,
      NULL,
      1,
      ' 4-17-1981',
      NULL,
      36.248104,
      NULL,
      NULL,
      2,
      NULL,
      0.288802,
      0,
      1,
      1,
      0,
      0,
      1.488182,
      1,
      NULL,
      NULL,
      1,
      1.537523,
      1,
      0,
      NULL,
      1,
      NULL,
      1.334692,
      0.592221,
      0.256709,
      2,
      NULL,
      3,
      3,
      0.090107,
      1.704355,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.880735,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.855705,
      1.745089,
      0.710230,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.931270,
      1,
      1,
      3.919424,
      4,
      0,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.397074,
      NULL,
      0.997787,
      NULL,
      1,
      5.517319,
      0.757219,
      0,
      0,
      0,
      NULL,
      1.804356,
      NULL,
      NULL,
      1.523222,
      0.286850,
      NULL,
      NULL,
      NULL,
      0.346675,
      NULL,
      0,
      6,
      2,
      7,
      3.700837,
      0.557270,
      1.714846,
      1.539148,
      NULL,
      4,
      5.169170,
      0,
      NULL,
      NULL,
      2,
      1.862510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.416586,
      1,
      1,
      0.946687,
      1.174960,
      1,
      1.465822,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.633474,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0.119403,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.898045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.176393,
      2.230855,
      0.254545,
      0,
      3.240045,
      1,
      3.703551,
      NULL,
      1.966663,
      1,
      2,
      0,
      NULL,
      1.902456,
      1,
      0.704580,
      1,
      1,
      1.001316,
      1.654834,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.195522,
      '01040',
      '',
      '',
      0.025770,
      '',
      '',
      '',
      NULL,
      NULL,
      '4202',
      '',
      5.245207,
      0.454997,
      NULL,
      1.770371,
      1.338432,
      NULL,
      2.654297,
      0,
      0);
commit;
end;
/


