set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8923682';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-3-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3302',
      '34212430',
      67.379990,
      62,
      '2402443',
      110,
      6,
      1.735818,
      3,
      NULL,
      1,
      ' 5- 4-1995',
      32,
      45.288675,
      0,
      NULL,
      3.736384,
      0,
      NULL,
      0.845307,
      1,
      2.901257,
      0.516568,
      NULL,
      1,
      1,
      2,
      1,
      0,
      0,
      1.807738,
      1.063671,
      1.961941,
      0,
      0.764300,
      1.250202,
      0,
      1.751891,
      NULL,
      NULL,
      NULL,
      1.333437,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0.241473,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      1.792122,
      1.940476,
      0.109186,
      1,
      NULL,
      1.664166,
      1,
      1,
      0,
      0,
      1,
      1.105553,
      0.296792,
      NULL,
      NULL,
      1.941616,
      3,
      1.769040,
      0,
      0.644703,
      1,
      3,
      NULL,
      NULL,
      0.834348,
      NULL,
      1.379836,
      NULL,
      1,
      0.856785,
      1,
      1,
      6.439851,
      5.254055,
      NULL,
      7.431725,
      4.949595,
      3,
      7,
      6,
      0,
      0,
      0.579294,
      0.954747,
      NULL,
      NULL,
      6,
      0.990385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.774042,
      NULL,
      1,
      0,
      0,
      1.110309,
      1.210692,
      1.647042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.864051,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.528751,
      1.203187,
      0.096394,
      0,
      0.508061,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.072653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.921564,
      NULL,
      1.467264,
      3,
      0,
      1,
      0.374950,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      0.516333,
      1.591385,
      0.096901,
      1.410914,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.622978,
      '03423',
      '',
      '',
      1.938743,
      '',
      '',
      NULL,
      4,
      '3030',
      '0200',
      '',
      3.805461,
      2,
      3,
      3.566623,
      NULL,
      2.177302,
      2,
      3.704600,
      NULL);
commit;
end;
/


