set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9312240';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-11-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '322',
      '22401230',
      32,
      5.537747,
      '4324142',
      86,
      6,
      3,
      0,
      '414431',
      NULL,
      ' 8-19-1999',
      21,
      NULL,
      NULL,
      NULL,
      0,
      3.221162,
      1.988591,
      1,
      0,
      NULL,
      1,
      0,
      1,
      0,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      1,
      1.746067,
      0,
      1,
      0.013488,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.464950,
      0.349775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.370769,
      NULL,
      0.878811,
      1.017272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.327170,
      NULL,
      NULL,
      0,
      1,
      0,
      0.785125,
      NULL,
      0,
      0,
      0,
      1.617759,
      NULL,
      0.904639,
      1,
      1.804002,
      0,
      1,
      NULL,
      1,
      0.751761,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      3,
      0,
      1.941058,
      4,
      3.360902,
      2.221071,
      1,
      0,
      0,
      2.759573,
      7,
      2,
      3.762378,
      3.023633,
      0,
      2.117302,
      6,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      8.730916,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.715248,
      0.147958,
      0,
      0,
      NULL,
      0.709109,
      1.283033,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.378709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.481919,
      1.387106,
      3.901830,
      5.690750,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.991247,
      0.305798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.891737,
      1,
      1.854305,
      0.122299,
      0,
      0.370458,
      NULL,
      1,
      NULL,
      1.929279,
      0,
      1.361252,
      0,
      1.847406,
      1.052646,
      NULL,
      NULL,
      0.461585,
      1.881428,
      1.237987,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.943906,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '34202',
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      1.360934,
      '',
      '',
      '',
      3,
      5,
      3.679736,
      0,
      0,
      1,
      3.332669,
      1,
      NULL);
commit;
end;
/


