set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9312240';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '120',
      '10130421',
      8.878645,
      43,
      '4003003',
      NULL,
      NULL,
      NULL,
      3,
      '001211',
      3,
      '10-13-1976',
      25.493447,
      NULL,
      0.189106,
      NULL,
      NULL,
      1,
      1.373919,
      NULL,
      NULL,
      1.782947,
      1.933488,
      NULL,
      1,
      0.780903,
      0,
      1,
      0.063087,
      1,
      0,
      1.763511,
      1,
      0.562488,
      0.557685,
      1,
      0.978521,
      1,
      1.440901,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.613315,
      1.883587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.490987,
      1.666961,
      1.329164,
      0.593636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.607047,
      0.176478,
      1.030073,
      1.693535,
      NULL,
      0,
      NULL,
      NULL,
      0.450212,
      0,
      1,
      NULL,
      0.519247,
      0.755899,
      0,
      0,
      NULL,
      1,
      3.571396,
      NULL,
      1,
      1,
      1.408878,
      1,
      NULL,
      1,
      1.087771,
      1,
      3.516528,
      NULL,
      2,
      2.038884,
      0.371990,
      2,
      1.162177,
      2.804785,
      1,
      NULL,
      1.112673,
      7,
      NULL,
      6.424483,
      1.127278,
      NULL,
      0.640176,
      1,
      NULL,
      NULL,
      1.341638,
      1.162751,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.879253,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      1.519705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.520513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      1.722193,
      NULL,
      NULL,
      NULL,
      NULL,
      1.941773,
      3.768610,
      1.797304,
      0.556277,
      NULL,
      1.290626,
      NULL,
      NULL,
      NULL,
      0,
      5.921329,
      0.623748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.507220,
      NULL,
      1.806805,
      1,
      0.748210,
      1,
      1,
      0.894581,
      0,
      NULL,
      1,
      0,
      0.756411,
      NULL,
      0,
      1,
      0,
      1.917354,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      '14422',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      1,
      '2241',
      '',
      '',
      NULL,
      NULL,
      1.668121,
      2.175112,
      2,
      2.281836,
      1,
      2,
      0);
commit;
end;
/


