set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9312240';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '320',
      '42221024',
      24,
      NULL,
      '3141330',
      37,
      1,
      1.848567,
      0,
      '214304',
      5,
      ' 3-21-1984',
      NULL,
      28.782544,
      1.160693,
      NULL,
      0.512720,
      1.116092,
      0.490740,
      0.521453,
      NULL,
      0,
      1,
      2,
      1.850568,
      1.650371,
      1.631432,
      0.196952,
      0.967988,
      0.321642,
      NULL,
      NULL,
      0.428858,
      1,
      1,
      NULL,
      NULL,
      0,
      0.231439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.219696,
      1.942842,
      1.498209,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.061202,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.095461,
      NULL,
      1,
      1.080117,
      1,
      1.853788,
      0.844516,
      0.356318,
      0,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      1.755138,
      1.374089,
      0,
      NULL,
      0,
      2.686636,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      4,
      1,
      1.751550,
      5.756374,
      NULL,
      0.011576,
      NULL,
      0.975489,
      NULL,
      4,
      8.573971,
      1.829434,
      0.260087,
      6.658179,
      9,
      NULL,
      7,
      0,
      1.010988,
      0.916366,
      0.016154,
      NULL,
      NULL,
      4.868115,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      0.559731,
      0.684704,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.123989,
      NULL,
      NULL,
      NULL,
      NULL,
      1.055541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.673797,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1.411020,
      2,
      6,
      1.693168,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.386161,
      3,
      1.828627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.603830,
      NULL,
      0.040302,
      1.859742,
      2,
      3.992135,
      3.715075,
      0.447248,
      2,
      1,
      NULL,
      0,
      NULL,
      1,
      1.066177,
      1.132758,
      0.310734,
      1.303858,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.343887,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      '1312',
      '',
      NULL,
      2,
      3,
      0.201284,
      4,
      NULL,
      1.848058,
      NULL,
      NULL,
      2.627698);
commit;
end;
/


