set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9312240';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '33103414',
      24,
      28,
      '3434433',
      8,
      3,
      0.733232,
      3,
      '321444',
      5.048622,
      NULL,
      NULL,
      1,
      1.055995,
      NULL,
      NULL,
      0.627161,
      1,
      0,
      1.853989,
      NULL,
      1,
      NULL,
      0.766474,
      0.554927,
      1.499862,
      1.342381,
      1.466070,
      1.262793,
      0.596612,
      1.610180,
      1,
      1,
      NULL,
      0.990132,
      0.732196,
      0,
      1.039035,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.272677,
      0.531914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.355845,
      1.090942,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.242966,
      0,
      0.383110,
      0.987163,
      NULL,
      0.514041,
      NULL,
      0,
      0.660166,
      1.665777,
      1.686190,
      1.453978,
      1.351853,
      0.717055,
      NULL,
      NULL,
      0.306464,
      0,
      NULL,
      NULL,
      NULL,
      4,
      0.022297,
      1.950797,
      1.039301,
      1,
      4.279812,
      0.470351,
      3,
      NULL,
      NULL,
      3,
      1,
      1.938313,
      2,
      1.388918,
      NULL,
      5,
      1,
      5,
      2,
      11.740577,
      8,
      0.123284,
      4,
      0,
      0.769914,
      1,
      1.360322,
      NULL,
      NULL,
      0.113382,
      1.072566,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.776349,
      NULL,
      NULL,
      1,
      0.696720,
      0.232251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.626771,
      NULL,
      NULL,
      NULL,
      NULL,
      1.717650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.297720,
      3,
      0.191021,
      NULL,
      NULL,
      NULL,
      1,
      1.099824,
      5.196694,
      4,
      0,
      0,
      0.281930,
      NULL,
      NULL,
      NULL,
      1,
      4,
      1.718791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.646340,
      NULL,
      0,
      0.736818,
      0,
      3.136423,
      NULL,
      3,
      1.869747,
      0.119662,
      1,
      0.334881,
      0,
      1,
      0,
      0,
      NULL,
      0,
      0.222924,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.810066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.212406,
      '31010',
      '',
      '',
      1.632540,
      '',
      '',
      '',
      1,
      '3242',
      NULL,
      '',
      3.049456,
      5,
      3.979609,
      1.575778,
      3.368665,
      2.751540,
      0,
      0.041898,
      1);
commit;
end;
/


