set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9312240';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1040',
      '00410014',
      33.546021,
      9,
      '1213401',
      113.244333,
      6,
      2,
      0,
      '100344',
      5.659975,
      NULL,
      7,
      54.263562,
      1.592251,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      0.410390,
      0,
      2,
      0,
      1.817723,
      0,
      1,
      0,
      NULL,
      NULL,
      0.054322,
      1.405235,
      NULL,
      0,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.637066,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.678567,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.082842,
      NULL,
      1,
      1.361844,
      1.715769,
      1.343147,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.004361,
      0,
      0,
      1,
      1,
      0.750793,
      0,
      1.465245,
      NULL,
      NULL,
      4.407112,
      1,
      0.163071,
      1,
      1.609996,
      1.827290,
      1,
      7,
      0.097812,
      0,
      3,
      2,
      3,
      6,
      1.787863,
      1.423568,
      1,
      NULL,
      1,
      NULL,
      6.640426,
      4,
      2,
      4,
      1.356997,
      0,
      0,
      NULL,
      NULL,
      NULL,
      7.996544,
      1.546969,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.572419,
      NULL,
      1,
      0,
      1,
      1.509084,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.161300,
      NULL,
      NULL,
      NULL,
      NULL,
      0.296521,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.844267,
      NULL,
      NULL,
      NULL,
      1.155742,
      1.493717,
      5,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.960408,
      0.792716,
      1.203458,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.908142,
      0,
      0,
      NULL,
      1.162120,
      1.641299,
      0,
      NULL,
      1.436174,
      NULL,
      1.368929,
      1.880321,
      1.985638,
      0,
      1.838713,
      1,
      0.145699,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.543726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '22431',
      '',
      '',
      0,
      '',
      '',
      NULL,
      3.325307,
      NULL,
      '',
      '',
      0.039581,
      1,
      0.677952,
      NULL,
      3,
      1.277358,
      NULL,
      0,
      3);
commit;
end;
/


