set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9312240';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-7-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3203',
      '01213441',
      14.455532,
      13,
      '0302222',
      NULL,
      6,
      NULL,
      1,
      NULL,
      3.418653,
      ' 5-14-1989',
      32,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3.709389,
      1,
      1.530938,
      1.672388,
      NULL,
      1.501386,
      NULL,
      0.062708,
      0,
      NULL,
      1.487641,
      0.418633,
      0,
      0.923629,
      2.849439,
      1,
      1,
      1.903077,
      1.223826,
      0,
      1.339153,
      0,
      1.126007,
      NULL,
      3.683554,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      7.507227,
      0.126034,
      2,
      1.080845,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0.960222,
      1,
      0.918562,
      1.116052,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.042982,
      1,
      1.584099,
      4,
      0,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.701899,
      0.274830,
      1,
      NULL,
      0.392913,
      0,
      0,
      NULL,
      1.417886,
      1.608840,
      0.853076,
      0.981391,
      0.022631,
      NULL,
      0.330734,
      1,
      1.194450,
      1.294714,
      NULL,
      0,
      2,
      1.009487,
      7.607179,
      3,
      1,
      4.234489,
      1.115836,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2.870254,
      5,
      NULL,
      1,
      0,
      3,
      NULL,
      0.138837,
      3,
      1,
      4.647651,
      NULL,
      4.348315,
      5.647759,
      NULL,
      0.630021,
      0.229278,
      0.265875,
      2.808145,
      1.729138,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      0,
      1.806686,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4.533673,
      2.892787,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.423625,
      0,
      6,
      NULL,
      0.166773,
      2,
      1.912946,
      NULL,
      NULL,
      NULL,
      0.107928,
      0.673403,
      1.973620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.490269,
      NULL,
      1,
      NULL,
      1.849864,
      1,
      1,
      1.516776,
      0.261608,
      NULL,
      1.035450,
      NULL,
      1,
      0.327806,
      1.283852,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.920354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      '11042',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '4011',
      '',
      '',
      4.587857,
      2.892398,
      0,
      3.541350,
      NULL,
      0.424001,
      3,
      1.292164,
      2.976223);
commit;
end;
/


