set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228176';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-3-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '4',
      NULL,
      NULL,
      '4134430',
      9,
      6,
      2.172206,
      3,
      '342414',
      1.342808,
      ' 2-20-1994',
      17,
      NULL,
      0,
      NULL,
      1.815734,
      NULL,
      1,
      0.444368,
      NULL,
      1,
      1,
      2,
      NULL,
      0.962021,
      NULL,
      0.686646,
      3,
      1.217969,
      0.483937,
      0,
      3.908898,
      1.288055,
      0.234436,
      1,
      0.808200,
      NULL,
      2,
      1,
      NULL,
      0,
      1.991923,
      0,
      NULL,
      NULL,
      0.359940,
      NULL,
      NULL,
      1.899524,
      0,
      0,
      1.503043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.794834,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.483319,
      NULL,
      4,
      0.967602,
      1.979419,
      NULL,
      0.643591,
      NULL,
      1,
      3,
      1.370929,
      1.722940,
      1.556652,
      1.781490,
      NULL,
      NULL,
      1.611661,
      6,
      1,
      0.917219,
      4,
      NULL,
      NULL,
      1,
      3.990026,
      NULL,
      2.160947,
      4.217913,
      0.318023,
      NULL,
      NULL,
      3,
      1.675973,
      1.717814,
      NULL,
      0.963573,
      8,
      0.914734,
      NULL,
      2,
      2.162171,
      1,
      1,
      1,
      3.874898,
      1,
      1.744723,
      2.217399,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0.588007,
      1,
      0.142501,
      1.374065,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.906678,
      NULL,
      1.334394,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.117562,
      1.741551,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      6,
      0.702654,
      6.949255,
      0,
      0.862279,
      NULL,
      NULL,
      NULL,
      1,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      0.719922,
      2,
      0,
      NULL,
      0.287135,
      0.616127,
      2.012944,
      1,
      1,
      0,
      0.379153,
      0,
      1.211932,
      NULL,
      1.796116,
      1.749719,
      0,
      0,
      0.871406,
      1.292941,
      2.874725,
      1,
      0.528759,
      0.782297,
      1,
      NULL,
      NULL,
      0.412728,
      0.872134,
      1,
      2,
      1.180828,
      1,
      0,
      0,
      1,
      NULL,
      0.586293,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.587699,
      1,
      0,
      NULL,
      NULL,
      0.746865,
      1,
      1.806375,
      2.567927,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0.644194,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.368947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.378108,
      '21432',
      '01214',
      '',
      1,
      '',
      NULL,
      NULL,
      1.228605,
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


