set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228176';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-7-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      NULL,
      NULL,
      '0434033',
      NULL,
      0,
      0.928346,
      0,
      '424142',
      NULL,
      ' 5-26-1977',
      23,
      NULL,
      1.344573,
      NULL,
      0,
      2.987416,
      NULL,
      NULL,
      1.002016,
      1,
      NULL,
      0,
      1.367958,
      NULL,
      3.391185,
      0,
      1,
      1,
      0.007372,
      1.326743,
      3,
      0.407681,
      NULL,
      1,
      0.692308,
      0,
      6.204659,
      1,
      1,
      0,
      1.993359,
      0,
      NULL,
      NULL,
      1,
      1,
      0.944839,
      0.717390,
      NULL,
      NULL,
      1.580815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.587383,
      NULL,
      5.753567,
      3.931144,
      1,
      3,
      NULL,
      5.479146,
      0,
      NULL,
      0.448444,
      5,
      0.626442,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.294271,
      1.759220,
      NULL,
      0,
      2.651428,
      1,
      0.797845,
      3,
      NULL,
      6.207118,
      1.459403,
      1,
      NULL,
      NULL,
      5,
      8.661790,
      7.121801,
      7.181062,
      1,
      7.347153,
      0.709714,
      0,
      3,
      6,
      8,
      1.858600,
      1.389410,
      7.187186,
      4,
      NULL,
      5.464041,
      3.698814,
      0.441985,
      0.871772,
      0,
      1.459513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.067829,
      NULL,
      NULL,
      0.082731,
      1.123402,
      0.452369,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      1.268609,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.290593,
      0.902337,
      NULL,
      NULL,
      NULL,
      2.125222,
      1.411574,
      5.480706,
      1,
      NULL,
      1,
      5.368289,
      0.679122,
      NULL,
      NULL,
      1.353690,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0.237016,
      1,
      1,
      1,
      3,
      3.126784,
      1,
      2,
      2.504608,
      0.446527,
      NULL,
      1.914253,
      2.207552,
      2,
      NULL,
      0.789256,
      0,
      NULL,
      1,
      0,
      0,
      0.157526,
      1.929812,
      1,
      0,
      1.312080,
      0.828194,
      NULL,
      NULL,
      0,
      1.340807,
      1.932003,
      1.062465,
      NULL,
      1,
      0,
      1,
      2.025586,
      NULL,
      0.487826,
      1,
      1.575359,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.893508,
      '42021',
      '10424',
      '',
      1.801167,
      '',
      '',
      '',
      0,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


