set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228176';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-12-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '210',
      NULL,
      15,
      20.147392,
      '0013341',
      111.457877,
      2,
      2,
      0,
      NULL,
      1,
      '10- 3-1992',
      59.953887,
      19.830049,
      1.758112,
      NULL,
      0.724834,
      1.229450,
      1.939075,
      1.567969,
      0,
      0.644990,
      0,
      0,
      NULL,
      NULL,
      4.235585,
      1,
      1.280581,
      1.289018,
      NULL,
      0.387924,
      2,
      1,
      1.258035,
      NULL,
      1.469602,
      0.537030,
      3.779650,
      0,
      0,
      NULL,
      3.985801,
      0,
      NULL,
      NULL,
      0.208675,
      NULL,
      NULL,
      0.011011,
      0.069394,
      0,
      0.927936,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.839114,
      0.514683,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.777880,
      0,
      1.099643,
      NULL,
      3.645910,
      1.987323,
      1.751170,
      NULL,
      0.861414,
      0.422942,
      NULL,
      1.467431,
      0,
      1.341603,
      1,
      1.463267,
      1,
      NULL,
      1.917132,
      NULL,
      0,
      NULL,
      NULL,
      0.360972,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2.948245,
      1,
      NULL,
      3.652125,
      8.588082,
      4.369161,
      9,
      NULL,
      6.053943,
      0.021659,
      NULL,
      1.927296,
      0,
      0.155091,
      1.677468,
      NULL,
      NULL,
      NULL,
      1.446529,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.151022,
      NULL,
      1,
      NULL,
      0,
      1.322611,
      0.664592,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.812956,
      NULL,
      NULL,
      NULL,
      NULL,
      1.357777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.657244,
      1.055008,
      7.003733,
      7,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.919094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.281631,
      1,
      1,
      1.243765,
      3,
      0.529193,
      1,
      NULL,
      1,
      2,
      0,
      0.713934,
      0,
      0,
      0.851198,
      1.133925,
      0.399961,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.498634,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.235873,
      '22210',
      '30241',
      '',
      0,
      '',
      '',
      '',
      0.562601,
      '',
      '',
      '',
      NULL,
      3,
      NULL,
      2,
      3.139836,
      3.075708,
      1,
      0,
      NULL);
commit;
end;
/


