set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228176';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-7-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '314',
      '20344404',
      12.592593,
      0,
      '4323241',
      98.315550,
      6,
      2,
      NULL,
      '404342',
      4.887868,
      NULL,
      8,
      23.873659,
      NULL,
      NULL,
      1,
      0.200480,
      0.798750,
      0,
      1,
      0,
      1.321001,
      2.491244,
      1,
      NULL,
      7.790716,
      1.459762,
      2,
      0,
      0,
      0,
      NULL,
      1.034615,
      1,
      1,
      0.982002,
      NULL,
      NULL,
      NULL,
      1.948360,
      2.466665,
      0.860037,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.420066,
      0,
      NULL,
      0.278921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      2,
      1.408036,
      0.488842,
      NULL,
      NULL,
      3.073909,
      1.956404,
      2,
      1,
      4,
      NULL,
      0,
      2.150997,
      0.227800,
      1.858085,
      1,
      1,
      NULL,
      1,
      1,
      0.190169,
      0,
      1,
      1.876766,
      0.879244,
      0,
      0,
      NULL,
      0.324641,
      NULL,
      3.980202,
      NULL,
      1,
      1.650799,
      3,
      2.413031,
      NULL,
      NULL,
      NULL,
      NULL,
      2.562568,
      4,
      3.297501,
      1.239639,
      NULL,
      4.847049,
      NULL,
      NULL,
      NULL,
      1.981073,
      8.277003,
      1,
      1.788666,
      3.305966,
      NULL,
      1.775525,
      3,
      0,
      0,
      1.887583,
      0.170227,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.206129,
      1,
      0,
      0,
      1,
      4.104379,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      3.922973,
      3.914682,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      3.403021,
      1.413656,
      3,
      3,
      4,
      NULL,
      4.142933,
      3,
      3.701137,
      2,
      6.632654,
      NULL,
      NULL,
      NULL,
      3.921520,
      10.694199,
      0.153196,
      5.952913,
      4,
      4.132534,
      NULL,
      1.019177,
      0.051966,
      1,
      3,
      2.332856,
      1,
      2.646069,
      0,
      0.860975,
      2,
      NULL,
      2.043129,
      NULL,
      0,
      0.456565,
      1.232874,
      1.427190,
      1,
      0.232700,
      NULL,
      1,
      2,
      1,
      2.566921,
      0.038594,
      1,
      1,
      2.882593,
      NULL,
      NULL,
      1,
      1,
      2,
      2.943297,
      NULL,
      NULL,
      2.426024,
      0.094683,
      1.329964,
      NULL,
      0,
      1.572060,
      0,
      NULL,
      2.984067,
      0.378167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      1.286130,
      2.131547,
      1,
      1,
      NULL,
      0.388899,
      0.832712,
      0.351949,
      0,
      0.602939,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      '31442',
      '',
      0.570347,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.531786,
      5.847771,
      1.345129,
      3.990592,
      4,
      NULL,
      NULL,
      2.997110,
      1.269208);
commit;
end;
/


