set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228176';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-12-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '134',
      '21030022',
      NULL,
      NULL,
      '0401411',
      107.498155,
      0,
      1.457587,
      2,
      '121032',
      NULL,
      ' 9-10-1981',
      16,
      NULL,
      0.823134,
      NULL,
      1.498569,
      0,
      1.752196,
      0,
      NULL,
      0,
      1.349398,
      NULL,
      0.199152,
      1.168649,
      2.692461,
      1.708206,
      1.216543,
      1,
      0.924750,
      0,
      3.585997,
      1,
      0.040850,
      1,
      1.923338,
      NULL,
      1.116379,
      0,
      1,
      2.335489,
      2.743467,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.000853,
      1,
      1.604512,
      0,
      0.313077,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5.273520,
      2.789202,
      0,
      0,
      2,
      1,
      NULL,
      NULL,
      3.362687,
      NULL,
      1.481795,
      1,
      0.573895,
      NULL,
      0.890534,
      NULL,
      NULL,
      0.755699,
      1.952553,
      1.604101,
      1.574064,
      0.683268,
      0.385386,
      1,
      0.698390,
      1,
      0.918216,
      1.633936,
      0.704036,
      0.396506,
      NULL,
      0,
      1,
      0,
      2.237051,
      0,
      0.747650,
      3,
      1.533465,
      NULL,
      NULL,
      NULL,
      NULL,
      1.287195,
      4,
      7,
      1.169188,
      6.640157,
      5.276735,
      8.455199,
      3.570904,
      8,
      9.811441,
      5,
      2.971152,
      7,
      NULL,
      1,
      1,
      2,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.359776,
      0,
      1,
      0,
      1,
      NULL,
      0.995285,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.504698,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.732177,
      NULL,
      6.265660,
      0.953575,
      0,
      5.159569,
      1,
      NULL,
      NULL,
      3,
      10.281365,
      3.337464,
      0,
      5,
      NULL,
      4.103302,
      0,
      1,
      1.094312,
      0,
      1.063533,
      2.106082,
      2,
      0,
      NULL,
      1.848120,
      0.636922,
      2.036295,
      2.758285,
      1.306000,
      3.605458,
      3.426599,
      NULL,
      NULL,
      3.016307,
      0,
      0,
      2.311491,
      0.204723,
      0.835549,
      2.299009,
      0,
      0,
      NULL,
      NULL,
      1,
      0.655070,
      0.922795,
      NULL,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.337962,
      0,
      0.728532,
      NULL,
      0,
      0.618614,
      1,
      NULL,
      0.846298,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.108250,
      '30401',
      '22443',
      '',
      1,
      NULL,
      NULL,
      '',
      0.056235,
      '',
      '',
      '',
      0,
      NULL,
      2,
      NULL,
      6,
      4.664634,
      NULL,
      2,
      1.814129);
commit;
end;
/


