set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228176';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-6-29 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '240',
      '03214000',
      NULL,
      NULL,
      '3120103',
      108,
      2,
      2.291189,
      2,
      '332110',
      4,
      ' 3- 2-1976',
      20,
      45.848705,
      0,
      NULL,
      1.638527,
      NULL,
      1,
      1.339926,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      5,
      1.789699,
      1,
      1.548677,
      0,
      1.473046,
      7.024331,
      NULL,
      1.257871,
      NULL,
      1,
      0.200067,
      4.767477,
      0,
      3.999137,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.197185,
      0,
      3.043456,
      1.843861,
      0.871879,
      1.980319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      5.757518,
      0,
      2,
      1.346968,
      1.447166,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.716254,
      0.542275,
      1.060875,
      2,
      1.318219,
      0,
      0.077084,
      0,
      1.396960,
      0.520949,
      0.474327,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      1,
      NULL,
      1,
      1.340778,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.052276,
      5,
      NULL,
      0.898984,
      6.723065,
      7,
      5,
      8,
      4.490779,
      7,
      0,
      NULL,
      5.959439,
      NULL,
      0.499319,
      1,
      2.691070,
      0,
      0,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.867631,
      NULL,
      NULL,
      1,
      1.931439,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      9.944013,
      2.449762,
      1.294346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.610669,
      NULL,
      1.849495,
      NULL,
      NULL,
      NULL,
      3,
      0,
      7.330908,
      NULL,
      7.863460,
      1,
      3.018754,
      0,
      NULL,
      NULL,
      0.406128,
      3.230439,
      2,
      3,
      3,
      1,
      2.954269,
      0.135582,
      1.866440,
      1.252293,
      1,
      2.881795,
      0,
      NULL,
      2,
      NULL,
      1.300456,
      NULL,
      2,
      1.013717,
      1,
      NULL,
      0,
      1.657998,
      1,
      1,
      0,
      1.930477,
      2.152162,
      1,
      NULL,
      2,
      NULL,
      0.884336,
      0,
      0.272939,
      NULL,
      0.026485,
      0.322204,
      0.939018,
      NULL,
      1,
      0.816788,
      0,
      0.049901,
      NULL,
      0.018954,
      0.235131,
      0,
      NULL,
      0.992788,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.331274,
      0.144165,
      0,
      NULL,
      1.692149,
      NULL,
      0.313854,
      0.847451,
      0.363374,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.179504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5,
      '02213',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      1,
      1.240358,
      NULL,
      0,
      0,
      3.715700,
      2.739107,
      3.629306,
      1);
commit;
end;
/


