set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9796997';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-2-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '002',
      '04303022',
      21.732989,
      3,
      NULL,
      5.449392,
      NULL,
      1,
      NULL,
      '241444',
      2.662234,
      '10-12-1987',
      171,
      59,
      1,
      NULL,
      1.639587,
      NULL,
      0.764115,
      NULL,
      NULL,
      2.703749,
      1.040300,
      0,
      NULL,
      0.345610,
      6.363525,
      0.847615,
      0,
      1.774269,
      0,
      1.247393,
      4.026464,
      0.436860,
      1,
      0,
      0.933509,
      0,
      6.088365,
      0,
      1,
      1,
      1.960203,
      1.503556,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.157896,
      1.981086,
      7,
      1,
      0,
      1,
      1.205258,
      NULL,
      NULL,
      0.400165,
      NULL,
      NULL,
      0.661475,
      1,
      1.896128,
      0,
      0,
      1.570537,
      0.632598,
      1,
      1.673861,
      5.805198,
      1.042030,
      1.876188,
      1.915840,
      2.220293,
      NULL,
      1.972360,
      1.974436,
      NULL,
      1.042829,
      NULL,
      0.517101,
      1.768229,
      1,
      1,
      0,
      1,
      1.876637,
      NULL,
      0,
      1.796570,
      0,
      1,
      1,
      1,
      0.017814,
      0.725567,
      NULL,
      NULL,
      0.775420,
      2,
      1,
      2.123591,
      0,
      NULL,
      1,
      1.751296,
      NULL,
      1.302577,
      0,
      NULL,
      1.265804,
      2.564601,
      0.422551,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.478180,
      1,
      0,
      1,
      NULL,
      1.257892,
      0.922023,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.747313,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      6.006810,
      5.177321,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.746180,
      5.162646,
      1.486284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.376327,
      2,
      1,
      0.277346,
      0,
      0.769695,
      0,
      NULL,
      0,
      1,
      1,
      0.101625,
      1.577240,
      0,
      NULL,
      0,
      NULL,
      0,
      0.500397,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '20421',
      '',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      0.259127,
      1,
      NULL,
      1,
      3.609855,
      NULL,
      1,
      1.779232);
commit;
end;
/


