set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9796997';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '440',
      NULL,
      NULL,
      55,
      '1342223',
      12.943305,
      0,
      1,
      2,
      '341011',
      4,
      ' 6-13-1993',
      9.791179,
      48,
      0.505104,
      NULL,
      0,
      1,
      NULL,
      1,
      1.371839,
      1.988482,
      0,
      0,
      0.764287,
      0,
      4,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2.168115,
      0,
      0.835272,
      1.525877,
      0,
      1.607411,
      3,
      1,
      0.480792,
      1.230402,
      1.094252,
      1.266042,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1.456330,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.895244,
      NULL,
      NULL,
      0.520373,
      0,
      1,
      0.206577,
      1.594224,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1,
      1.377866,
      1,
      0.318561,
      0.790949,
      0.781208,
      NULL,
      1,
      1.996347,
      1.189332,
      0,
      1,
      0,
      1.385517,
      NULL,
      0.964032,
      1,
      1.585500,
      NULL,
      0.315553,
      0,
      0.912372,
      NULL,
      0.578438,
      1.870236,
      NULL,
      NULL,
      NULL,
      0.516081,
      0.897010,
      0.888191,
      0,
      NULL,
      1,
      4.768786,
      1.844402,
      4,
      0,
      5.510317,
      2.354602,
      1,
      0,
      0,
      1.941079,
      NULL,
      NULL,
      2.383017,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.715410,
      NULL,
      0,
      0,
      1,
      1.072347,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.347372,
      NULL,
      3,
      2,
      1,
      1.112922,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.400570,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2.856462,
      1.337668,
      0,
      1.326944,
      NULL,
      0,
      1,
      0.808371,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      1.002978,
      1.580088,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      '30441',
      '',
      '',
      1.094427,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      1.931902,
      1,
      NULL,
      3,
      1.091289,
      2.168273,
      3,
      0);
commit;
end;
/


