set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9206190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '413',
      '21',
      30.106211,
      35,
      '0022442',
      102,
      NULL,
      2.470638,
      0,
      '442132',
      1.070528,
      ' 0-25-1975',
      41,
      54.611325,
      0,
      NULL,
      0.495546,
      0,
      0.211054,
      0.118077,
      0,
      2.905894,
      1.406637,
      1.614352,
      NULL,
      0.174166,
      NULL,
      0.804948,
      NULL,
      1.207417,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.220458,
      1.498012,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.957783,
      1,
      1,
      0.559920,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.325851,
      1,
      0,
      NULL,
      1,
      0,
      0,
      1,
      0.713456,
      0.958924,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.699263,
      0.366757,
      3,
      0,
      8.133193,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1.995433,
      4.283000,
      NULL,
      0,
      5,
      7.773054,
      3,
      6.798381,
      1.683295,
      9.930281,
      3,
      NULL,
      NULL,
      6,
      NULL,
      2.641553,
      0.010703,
      NULL,
      NULL,
      4.884245,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.752580,
      1,
      0.363771,
      1.470412,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.391756,
      NULL,
      NULL,
      NULL,
      NULL,
      1.667690,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.837766,
      3,
      0.942886,
      NULL,
      NULL,
      NULL,
      1.219767,
      2,
      4,
      0,
      3.481681,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.213430,
      4,
      1.016398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.110562,
      NULL,
      1.239316,
      0,
      1.968637,
      3,
      2.783160,
      NULL,
      1.564087,
      NULL,
      3.902618,
      NULL,
      1.744053,
      0.031882,
      0.048398,
      1.543408,
      0.409837,
      0.277888,
      0,
      0.165530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.506827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.400973,
      '10033',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1.584158,
      '',
      '',
      '',
      5,
      2,
      1.786612,
      1,
      1,
      0,
      0,
      NULL,
      0);
commit;
end;
/


