set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9206190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-9-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '32310344',
      51.896234,
      24.278822,
      '3002213',
      23.239403,
      5,
      3,
      NULL,
      '403402',
      1.307098,
      ' 6- 4-2002',
      44,
      53.317982,
      1,
      NULL,
      1.617795,
      1.224598,
      0.060073,
      0.195146,
      0,
      3.858308,
      NULL,
      1,
      0.114393,
      0,
      1.309032,
      0,
      1.573299,
      NULL,
      0.977073,
      NULL,
      0.551384,
      1.218104,
      1,
      1.897640,
      0,
      1.422709,
      0.156354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.450841,
      NULL,
      1.141791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.201560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.600174,
      1.663511,
      1.508001,
      1.521836,
      0.114665,
      0,
      0,
      1.085031,
      0,
      NULL,
      1.217688,
      1.780049,
      0,
      1.890611,
      0,
      NULL,
      0.225258,
      0,
      1.431052,
      NULL,
      1.859402,
      2,
      NULL,
      NULL,
      3.915421,
      1.775415,
      3.792005,
      1.977649,
      5.231649,
      7.425905,
      NULL,
      1,
      1,
      NULL,
      3,
      4.209118,
      1.047946,
      3,
      7,
      NULL,
      4,
      1,
      4,
      4.591624,
      NULL,
      NULL,
      1,
      2.427452,
      0.212595,
      NULL,
      NULL,
      1.690055,
      1.586302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      1,
      NULL,
      1.751932,
      1.968169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.007193,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.916163,
      3.028867,
      0,
      NULL,
      NULL,
      NULL,
      5.534573,
      1,
      6.182339,
      5,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.882440,
      0.676278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.698285,
      0,
      0,
      0,
      2.538105,
      3,
      2.781769,
      1,
      1,
      0,
      1,
      1.804776,
      NULL,
      0.229426,
      NULL,
      1.650787,
      0,
      1.525070,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.734937,
      NULL,
      '',
      NULL,
      2,
      5,
      3.934812,
      1,
      NULL,
      2.575756,
      3.939896,
      3.712836,
      0.360597);
commit;
end;
/


