set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9206190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-9-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '012',
      '41044441',
      4.709495,
      65.481109,
      '4303033',
      231,
      4,
      2,
      1,
      '021001',
      0,
      NULL,
      NULL,
      52,
      1,
      NULL,
      0.351991,
      1,
      0,
      NULL,
      1,
      2,
      NULL,
      NULL,
      0.612816,
      1.214921,
      1.609930,
      0,
      NULL,
      1.353794,
      1.089450,
      0,
      0.590452,
      0,
      1.723379,
      1.775359,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.900308,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.091455,
      0,
      1.491807,
      1.118982,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.909787,
      0.078355,
      3,
      1.406296,
      1,
      0,
      0,
      0,
      1.740861,
      NULL,
      0,
      1.261089,
      1,
      1.248384,
      0.396367,
      1,
      0.333841,
      NULL,
      0.021904,
      0,
      NULL,
      2,
      4.287943,
      1,
      2.224682,
      1,
      NULL,
      6.393111,
      1,
      4.477814,
      4.073173,
      NULL,
      NULL,
      3,
      5.184670,
      5.927344,
      6,
      7,
      1.129530,
      1,
      NULL,
      NULL,
      5,
      3,
      1.521510,
      3.609819,
      1.618538,
      NULL,
      NULL,
      2,
      1.180513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.108720,
      1,
      0,
      0,
      1.505066,
      1,
      0.465335,
      1.525031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      2,
      1.297187,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.221665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.900591,
      5.860143,
      8,
      7,
      2.422453,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.785180,
      3,
      1.088577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.427761,
      0.698089,
      3,
      1.509304,
      2.026050,
      0,
      1.351554,
      0.829196,
      1.712294,
      0,
      1.478192,
      1.353429,
      1.240132,
      0,
      NULL,
      0.661500,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      '1303',
      NULL,
      NULL,
      0.721698,
      1.960213,
      1,
      0,
      2.720993,
      NULL,
      2.439767,
      NULL,
      2);
commit;
end;
/


