set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9206190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '243',
      '24142202',
      4.035614,
      51.611165,
      '2433001',
      265,
      1,
      2.154556,
      1,
      '143101',
      3.356750,
      ' 9- 8-1990',
      NULL,
      20,
      1,
      NULL,
      3.749727,
      0,
      1,
      0,
      2.757396,
      0,
      0,
      0.940818,
      1,
      NULL,
      1.038809,
      1.971978,
      1.612738,
      1.355412,
      NULL,
      NULL,
      1.094076,
      1.739485,
      1.679725,
      0.013423,
      0.414376,
      1.462030,
      1.213170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.078239,
      1,
      0.658470,
      1.401809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.051272,
      0,
      0.754257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.833414,
      1.659804,
      0.053999,
      NULL,
      3.717437,
      0.431144,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.887462,
      0,
      0.315391,
      0.650256,
      0.058722,
      0.623176,
      NULL,
      NULL,
      NULL,
      0,
      7.167656,
      NULL,
      0.889943,
      2.324911,
      1.942891,
      3,
      0,
      NULL,
      5,
      0,
      NULL,
      1,
      5,
      3.495444,
      NULL,
      3,
      3.564397,
      9.754370,
      2,
      NULL,
      11,
      5,
      0.951467,
      0.155404,
      1.574881,
      0.500418,
      6.754711,
      0.775923,
      NULL,
      NULL,
      4.379119,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.396526,
      0,
      1,
      1,
      1.309828,
      1,
      3,
      1.210908,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.748848,
      NULL,
      NULL,
      NULL,
      NULL,
      2.233929,
      3.534577,
      NULL,
      NULL,
      0,
      2.941302,
      3.814403,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4.396393,
      1.683444,
      4,
      1,
      2,
      1.718965,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.645058,
      0,
      0,
      0.801032,
      3.746480,
      0,
      1.498503,
      NULL,
      0.923491,
      3.853768,
      NULL,
      0,
      0.359288,
      1,
      NULL,
      0,
      0.489013,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.587106,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      '40023',
      '',
      '',
      1,
      '',
      NULL,
      NULL,
      1.129366,
      '1233',
      '',
      '',
      3,
      4,
      2,
      3,
      NULL,
      2,
      3,
      NULL,
      0.715553);
commit;
end;
/


