set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9206190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-4-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3132',
      '03022210',
      47.040284,
      71.659954,
      '3140203',
      267.770478,
      0,
      2,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      46.067354,
      NULL,
      NULL,
      2.244852,
      3,
      NULL,
      0,
      NULL,
      NULL,
      0.588200,
      1.416760,
      NULL,
      NULL,
      1.140738,
      0,
      0,
      0.167171,
      0.700292,
      1.253307,
      0,
      1,
      0.408615,
      NULL,
      0.873541,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.828652,
      NULL,
      NULL,
      0.553649,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1.353192,
      1.769172,
      0.105781,
      NULL,
      0,
      0,
      0,
      0,
      0.775843,
      0,
      1.713642,
      0.551299,
      1.831935,
      1.042716,
      NULL,
      NULL,
      NULL,
      1.210773,
      1.266292,
      NULL,
      NULL,
      0.951267,
      4.238433,
      0,
      0,
      5,
      NULL,
      5.696265,
      0.256130,
      6,
      NULL,
      3,
      3.991200,
      3.204985,
      7.885265,
      2,
      7,
      7.265038,
      5,
      NULL,
      NULL,
      1,
      0.117876,
      NULL,
      0.954499,
      NULL,
      NULL,
      5.192489,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.838646,
      NULL,
      0,
      1,
      0,
      1.963026,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.465383,
      NULL,
      6.157106,
      1.741520,
      1.311930,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.079969,
      0.340857,
      1.099812,
      NULL,
      NULL,
      NULL,
      NULL,
      0.200467,
      0,
      NULL,
      4.145984,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.387242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.652240,
      NULL,
      0.397543,
      0.637513,
      NULL,
      3.757760,
      2,
      1.205927,
      1,
      0.477160,
      NULL,
      1,
      1,
      1.256633,
      0.462899,
      NULL,
      1.976406,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.842978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.016047,
      '14301',
      '',
      '',
      0.029926,
      '',
      '',
      NULL,
      NULL,
      NULL,
      '4111',
      NULL,
      NULL,
      1.766277,
      1,
      1,
      3,
      1,
      1.847315,
      0,
      1);
commit;
end;
/


