set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9206190';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4021',
      '41130200',
      10.008665,
      42.170268,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      ' 7-18-1978',
      NULL,
      1,
      1.566906,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.713105,
      1,
      1,
      NULL,
      1.771350,
      0,
      0,
      1.845958,
      1,
      1.614210,
      2.855068,
      NULL,
      1.386634,
      0.044064,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.143242,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.295636,
      NULL,
      0,
      1.913908,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.394608,
      0.623756,
      1,
      1.499875,
      1.501698,
      1,
      1.076318,
      NULL,
      0,
      NULL,
      1.350928,
      7,
      3,
      NULL,
      2,
      0.256454,
      7,
      1.377161,
      3.894564,
      1,
      2.444274,
      1.193738,
      2,
      4,
      NULL,
      5.762786,
      2.273700,
      5.752420,
      1.290745,
      6,
      5,
      9.896301,
      3.013527,
      NULL,
      8,
      NULL,
      1.647218,
      2.931690,
      1.509371,
      NULL,
      NULL,
      1.037436,
      0.352883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.898709,
      0,
      1,
      1,
      NULL,
      1.813886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.422247,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.165095,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.354573,
      0.351754,
      4,
      0,
      0.597221,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.747330,
      1,
      0.542064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.457441,
      0.450497,
      0,
      NULL,
      1.120987,
      0.012071,
      0.499238,
      2,
      1,
      1.179803,
      NULL,
      1,
      0.353705,
      NULL,
      NULL,
      NULL,
      0.013084,
      1.869121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.040127,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '01222',
      NULL,
      '',
      1,
      '',
      '',
      '',
      3,
      '1124',
      '2131',
      '',
      0,
      NULL,
      0.045455,
      1,
      1,
      3,
      1.164093,
      0,
      0);
commit;
end;
/


