set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9913006';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2112',
      '23224224',
      59,
      10,
      '3202440',
      NULL,
      3,
      1,
      NULL,
      '101033',
      5,
      ' 7-11-1993',
      10.320173,
      61,
      0,
      NULL,
      NULL,
      NULL,
      1.845330,
      1.807572,
      1,
      NULL,
      NULL,
      0,
      0.165204,
      1,
      9,
      0,
      1,
      1.620033,
      0.991492,
      1,
      5.168956,
      3.816016,
      6,
      3,
      NULL,
      NULL,
      9.527364,
      1,
      0.729974,
      2,
      1,
      0.616979,
      NULL,
      NULL,
      NULL,
      3.306416,
      NULL,
      3.034210,
      0.645190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.628335,
      1,
      1,
      1,
      0,
      0.806520,
      1,
      0,
      NULL,
      1,
      NULL,
      1.457370,
      0.439208,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      5.527645,
      0.191227,
      0,
      2.493215,
      1,
      4,
      1.925892,
      3.772036,
      4,
      2,
      NULL,
      5.192955,
      NULL,
      1.375167,
      5,
      1.434311,
      8,
      1.411984,
      7,
      2,
      4.451269,
      5.766473,
      1.579038,
      0.563813,
      2,
      3,
      1.550243,
      1,
      7.356900,
      1.528738,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.483746,
      1,
      0,
      1,
      1,
      0.154605,
      0.325844,
      1.469486,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      1.885519,
      2,
      1,
      0,
      3.194336,
      3,
      2.069225,
      3,
      0.879727,
      3,
      3,
      0.822211,
      0,
      6.302497,
      NULL,
      2.240400,
      2.115820,
      5,
      1,
      6.675962,
      1.107913,
      0,
      NULL,
      1,
      9.506102,
      NULL,
      3.330508,
      4,
      1,
      1,
      1,
      NULL,
      0,
      1.909724,
      NULL,
      2,
      2,
      2.523928,
      0.438437,
      NULL,
      0.988145,
      2.193538,
      3,
      0.905836,
      NULL,
      NULL,
      0,
      1.066246,
      1.232475,
      1.056717,
      0.560266,
      0.723406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '11332',
      '',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      3.852120,
      3,
      NULL,
      NULL,
      0.529500,
      2.535480,
      3.844363,
      3.810191,
      0.849936);
commit;
end;
/


