set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8212287';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-4-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      NULL,
      NULL,
      '0421013',
      10.992729,
      NULL,
      NULL,
      NULL,
      '444022',
      3,
      ' 3- 1-1998',
      39,
      NULL,
      1,
      NULL,
      0.392760,
      3,
      0.317149,
      0.180717,
      1.996502,
      NULL,
      1.406946,
      2.248881,
      NULL,
      0.363719,
      1,
      0.833621,
      1.578224,
      0.173932,
      0.329258,
      NULL,
      5,
      1.936991,
      1,
      0,
      0,
      1,
      1,
      2,
      0.703227,
      1.081303,
      1.103504,
      NULL,
      NULL,
      NULL,
      3.756304,
      1,
      NULL,
      NULL,
      0.570426,
      1.918339,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.887961,
      1.008707,
      0.328282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.955916,
      3.180689,
      0.556965,
      NULL,
      0.835395,
      1,
      1.085390,
      NULL,
      NULL,
      0,
      1.768160,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      1.076777,
      1.800198,
      1.167885,
      1.780813,
      1,
      0.136204,
      1.221632,
      0,
      2,
      0.890205,
      0,
      NULL,
      1.011993,
      0,
      4,
      1.316251,
      1.379260,
      7.706033,
      NULL,
      8,
      4,
      3,
      3.220593,
      2.811296,
      NULL,
      5,
      0.629985,
      0.691080,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.597724,
      0,
      NULL,
      0,
      NULL,
      3,
      0,
      1.492484,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      4,
      0.515190,
      3,
      0.987139,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      7,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2.793214,
      6.656900,
      1.558240,
      0.585853,
      0,
      1,
      1,
      0,
      1.532969,
      1,
      NULL,
      1,
      NULL,
      0,
      3.198746,
      3,
      0.198843,
      1.234941,
      2,
      0,
      1.623916,
      0.403447,
      NULL,
      0,
      0,
      NULL,
      0,
      0.294504,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.194686,
      '33432',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1.499734,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


